classdef class_REVS_datalog < class_REVS_logging_object
	%class_REVS_datalog
	%   Definition of class_REVS_datalog class
	
	properties
		
		
		
	end
	
	methods
		
		function obj  = 	class_REVS_datalog()
			
			% Get list of maatching workspace variables
			ws_vars = sort(evalin('caller',['who(''dl__*'');']));
			
			for v = 1:length(ws_vars)
				
				% Only load non-empty data
				if ~evalin('caller',['isempty(', ws_vars{v} ,');'] )
					% root field to work off - all
					working = obj;
					
					var_fields = strsplit( ws_vars{v}, '__');
					for f = 2:(length(var_fields)-1)
						% Add nonexistent properties
						if ~isprop( working,var_fields{f})
							working.addprop(var_fields{f});
							working.(var_fields{f}) = class_REVS_logging_object(obj);
						end
						% Move along tree
						working = working.(var_fields{f});
					end
					
					% Add final field & Load data
					working.addprop( var_fields{end} );
					working.( var_fields{end} ) = evalin('caller',ws_vars{v});
					
				end
				
				% cleanup workspace
				evalin('caller',['clear ', ws_vars{v}]);
			end
			
			%After data is loaded add calculated properties
			obj.add_calculated_properties;
			
			
		end
		
	end
	
	
end

