classdef class_REVS_default_CVM_sim_config < class_REVS_sim_config
    %class_REVS_sim_config holds values that define key simulation
    %parameters
        
    properties
        
    end
    
    methods
        
        function obj = class_REVS_default_CVM_sim_config()
                    
            obj.add_key('package',       'alias',    'PKG',  'eval', false);  % a convenient way to identify and filter tech packages in the output file
            obj.add_key('unique_id',    'alias',    'UKN');  % a convenient way to identify which unique key number associates with this run

            obj.add_key('powertrain_type',      'alias', 'PTRAIN');
             
            obj.add_key('drive_cycle',          'alias',    'CYC',  'eval', false);
            obj.add_key('engine',               'alias',    'ENG',  'eval', false);
            obj.add_key('transmission',         'alias',    'TRANS',  'eval', false);
            obj.add_key('vehicle',              'alias',    'VEH',  'eval', false);
            obj.add_key('electric',             'alias',    'ELEC',  'eval', false);
            obj.add_key('accessory',            'alias',    'ACC',  'eval', false);
            obj.add_key('controls',             'alias',    'CON',  'eval', false);
            obj.add_key('driver',               'alias',    'DRV',  'eval', false, 'default', 'driver=class_REVS_driver;');
            obj.add_key('ambient',              'alias',    'AMB',  'eval', false, 'default', 'ambient=class_REVS_ambient;');
            
            obj.add_key('fuel',                 'alias',    'FUEL',  'eval', false);
            
            obj.add_key('vehicle_lbs',                  'alias', 'VEH_LBS');                % sets vehicle mass, dynamic mass = 1.03 * vehicle mass
            obj.add_key('vehicle_kg',                   'alias', 'VEH_KG');
            obj.add_key('performance_mass_penalty_kg',  'alias', 'PERF_KG', 'default', 0);  % additional mass added during performance drive cycle

            obj.add_key('ETW_lbs',          'alias', 'ETW_LBS');    % sets vehicle mass, dynamic mass = 1.015 * vehicle mass (ETW includes 1.5% additional inertia already)
            obj.add_key('ETW_kg',           'alias', 'ETW_KG');
            obj.add_key('ETW_multiplier',   'alias', 'ETW_MLT', 'default', 1.0);

            obj.add_key('target_A_lbs',     'alias', 'TRGA_LBS');
            obj.add_key('target_B_lbs',     'alias', 'TRGB_LBS');
            obj.add_key('target_C_lbs',     'alias', 'TRGC_LBS');

            obj.add_key('dyno_set_A_lbs',   'alias', 'DYNA_LBS');
            obj.add_key('dyno_set_B_lbs',   'alias', 'DYNB_LBS');
            obj.add_key('dyno_set_C_lbs',   'alias', 'DYNC_LBS');

            obj.add_key('calc_ABC_adjust',  'alias', 'CALC_ABC_ADJ', 'default', false);

            obj.add_key('target_A_N',       'alias', 'TRGA_N');
            obj.add_key('target_B_N',       'alias', 'TRGB_N');
            obj.add_key('target_C_N',       'alias', 'TRGC_N');

            obj.add_key('dyno_set_A_N',     'alias', 'DYNA_N');
            obj.add_key('dyno_set_B_N',     'alias', 'DYNB_N');
            obj.add_key('dyno_set_C_N',     'alias', 'DYNC_N');

            obj.add_key('adjust_A_lbs',     'alias', 'ADJA_LBS');
            obj.add_key('adjust_B_lbs',     'alias', 'ADJB_LBS');
            obj.add_key('adjust_C_lbs',     'alias', 'ADJC_LBS');

            obj.add_key('adjust_A_N',       'alias', 'ADJA_N');
            obj.add_key('adjust_B_N',       'alias', 'ADJB_N');
            obj.add_key('adjust_C_N',       'alias', 'ADJC_N');

            obj.add_key('roadload_multiplier', 'alias', 'RL_MLT', 'default', 1.0);
            
            obj.add_key('start_stop',              'alias', 'SS', 'default', 0);
            obj.add_key('weight_reduction',        'alias', 'WR_PCT', 'default', 0);
            obj.add_key('improve_aero',            'alias', 'AE_PCT', 'default', 0);
            obj.add_key('improve_crr',             'alias', 'RR_PCT', 'default', 0);

             obj.add_key('engine_scale_pct'                  ,'alias','ES_PCT','default', 100);
             obj.add_key('engine_scale_kW'                   ,'alias','ES_KW');
             obj.add_key('engine_scale_hp'                   ,'alias','ES_HP');
             obj.add_key('engine_scale_L'                      ,'alias','ES_L');
             obj.add_key('engine_scale_BSFC'                  ,'alias','ES_BSFC','default', 1);
             obj.add_key('engine_scale_num_cylinders'          ,'alias','ES_CYL');
             obj.add_key('engine_deac_scale_pct'              ,'alias','DEAC_SCALE_PCT', 'default', 100);
             obj.add_key('engine_deac_max_reduction_pct'      ,'alias','DEAC_MAX_RED_PCT');
             obj.add_key('engine_deac_reduction_curve'          ,'alias','DEAC_RED_CRV');
             obj.add_key('engine_deac_activation_delay_secs'  ,'alias','DEAC_ACT_DLY_SECS');
             obj.add_key('engine_deac_C_cyl_pct'              ,'alias','DEAC_C_CYL_PCT','default', 0);    % adds continuous deac to an engine, percentage of cylinders to deactivate
             obj.add_key('engine_deac_D_cyl_pct'              ,'alias','DEAC_D_CYL_PCT','default', 0);    % adds discrete deac to an engine, percentage of cylinders to deactivate
             obj.add_key('engine_DCP_DVVL'                      ,'alias','DCP_DVVL','default', 0);
             obj.add_key('engine_CCP_DVVL'                      ,'alias','CCP_DVVL','default', 0);
             obj.add_key('engine_DCP_CVVL'                      ,'alias','DCP_CVVL','default', 0);
             obj.add_key('engine_DCP'                          ,'alias','DCP','default', 0);
             obj.add_key('engine_CCP'                          ,'alias','CCP','default', 0);
             obj.add_key('engine_GDI'                          ,'alias','GDI','default', 0);
             obj.add_key('engine_transient_fuel_penalty',      'alias','TFP','default', 1);
             
             obj.add_key('separate_FTP_cold_correction',        'alias', 'CC_SEP');

            obj.add_key('performance_baseline',         'alias','PB','default', 0);
            obj.add_key('performance_neutral',          'alias','PN','default', 0);

            obj.add_key('FDR',                          'alias','FDR');
            obj.add_key('FDR_efficiency_norm',          'alias','FDR_EFF');
            obj.add_key('FDR_auto',                     'alias','FDR_AUTO','default', 0);
            obj.add_key('NV_ratio',                     'alias','NV_RATIO','default', 0);

            obj.add_key('TC_K_factor',                  'alias','TCK');
            obj.add_key('TC_K_factor_auto',             'alias','TCK_AUTO','default', 0);
            obj.add_key('TC_torque_ratio',              'alias','TCTR');
            obj.add_key('TC_torque_ratio_auto',         'alias','TCTR_AUTO','default', 0);
            obj.add_key('TC_lockup_efficiency_pct',     'alias','TCLUEFF_PCT');

            obj.add_key('engine_vintage',               'alias','ENG_VTG');
            obj.add_key('transmission_vintage',         'alias','TRX_VTG');

            obj.add_key('vehicle_type',                 'alias','VEH_TYPE',  'eval', false);
            obj.add_key('vehicle_manufacturer',         'alias','VEH_MFR',   'eval', false);
            obj.add_key('vehicle_model',                'alias','VEH_MDL',   'eval', false);
            obj.add_key('vehicle_description',          'alias','VEH_DESC',  'eval', false);

            obj.add_key('normalize_transmission_rated_torque',  'alias','NTRT','default', 0);
            obj.add_key('normalize_shift',                      'alias','AS','default', 0);
            obj.add_key('normalize_lockup',                     'alias','LU','default', 0);

            obj.add_key('external_drive_cycle',             'alias',    'XCYC');   % 1=override speed/time, leave bags alone, 2=create new drive cycle
            obj.add_key('external_shift',                   'alias',    'XSHFT');
            obj.add_key('external_lockup',                  'alias',    'XLOCK');
            obj.add_key('external_accessory_elec',          'alias',    'XEACC',  'eval', false);
            obj.add_key('external_accessory_mech',          'alias',    'XMACC',  'eval', false);
            obj.add_key('external_cyl_deac',                'alias',    'XDEAC');
            
            obj.add_key('test_data',                        'alias',    'DATA');
            obj.add_key('test_data_index',                  'alias',    'DATA_INDEX', 'default', 1);
        end
        
    end
    
    
    methods 
       
        % Abstract method (must be implemented by concrete subclass) to
        % convert configuration into workspace of model inputs
        function workspace = prepare_case_workspace(sim_config)
        
            handle_param = @class_REVS_sim_config.handle_param;

            handle_param( sim_config.ambient)
            
            handle_param( sim_config.engine)
            handle_param( sim_config.transmission)
            handle_param( sim_config.vehicle)
            
            handle_param( sim_config.electric)
            handle_param( sim_config.accessory)
            
            handle_param( sim_config.controls)
            handle_param( sim_config.driver)
            
            handle_param( sim_config.drive_cycle)
            
            
             %% powertrain type
            if sim_config.powertrain_type
                vehicle.powertrain_type = eval(['enum_powertrain_type.' sim_config.powertrain_type]);
            end

            %% external sim stimuli

            handle_param( sim_config.test_data)            
            test_data_index = sim_config.test_data_index;
            
            %% powertrain type
            if ~isempty(sim_config.powertrain_type)
                vehicle.powertrain_type = eval(['enum_powertrain_type.' sim_config.powertrain_type]);
            end

            %% external sim stimuli
            if ~isempty(sim_config.external_accessory_elec) % && sim_config.external_drive_cycle
                accessories.generic_loss                                            = class_REVS_accessory_load();
                accessories.generic_loss.electrical_loss_map_A.axis_1.signal        = 'cycle_pos_secs';
                accessories.generic_loss.electrical_loss_map_A.axis_1.breakpoints   = evalin('base',[sim_config.test_data '(' num2str(sim_config.test_data_index) ').time;']);
                accessories.generic_loss.electrical_loss_map_A.table = []; % clear table
                accessories.generic_loss.electrical_loss_map_A.table(:,1)           = evalin('base',[sim_config.test_data '(' num2str(sim_config.test_data_index) ').' sim_config.external_accessory_elec ';']);
            end

            if ~isempty(sim_config.external_accessory_mech) % && sim_config.external_drive_cycle

            end
            
            if sim_config.external_drive_cycle
                    % user should load canonical cycle to provide bags/phase times etc,
                    % but override vehicle speed with new data
                    drive_cycle.cycle_time      = eval([sim_config.test_data '(' num2str(sim_config.test_data_index) ').time;']);
                    drive_cycle.cycle_speed_mps = eval([sim_config.test_data '(' num2str(sim_config.test_data_index) ').vehicle.dyno_speed_mps;']);
                    % TODO: May also want to load test phase information
                    % and allow drive cycle generation if one not already
                    % loaded
            end

            if sim_config.external_shift
                if transmission.type == enum_transmission_type.CVT
                    transmission.gear_strategy = class_REVS_external_shift_CVT;
                    transmission.gear_strategy.time_secs = eval([sim_config.test_data '(' num2str(sim_config.test_data_index) ').time;']);
                    transmission.gear_strategy.CVT_ratio = eval([sim_config.test_data '(' num2str(sim_config.test_data_index) ').transmission.commanded_CVT_ratio;']);
                else
                    transmission.gear_strategy = class_REVS_external_shift;
                    transmission.gear_strategy.time_secs = eval([sim_config.test_data '(' num2str(sim_config.test_data_index) ').time;']);
                    transmission.gear_strategy.gear_num  = eval([sim_config.test_data '(' num2str(sim_config.test_data_index) ').transmission.commanded_gear_number;']);
                end
            end

            if sim_config.external_lockup
                transmission.tcc_strategy           = class_REVS_external_lockup;
                transmission.tcc_strategy.time_secs = eval([sim_config.test_data '(' num2str(sim_config.test_data_index) ').time;']);
                transmission.tcc_strategy.lockup_cmd   = eval([sim_config.test_data '(' num2str(sim_config.test_data_index) ').transmission.launch_device_lockup_norm;']);
            end

            if ~isempty(sim_config.external_cyl_deac) && sim_config.external_cyl_deac
                engine.deac_strategy.type = enum_engine_deac_select.external_deac;
                engine.deac_strategy.time_secs = eval([sim_config.test_data '(' num2str(sim_config.test_data_index) ').time;']);
                engine.deac_strategy.deac_norm = eval([sim_config.test_data '(' num2str(sim_config.test_data_index) ').engine.cylinder_deac_norm;']);
            end
            
            
            
            %% base roadload

            if sim_config.target_A_lbs
                vehicle.coastdown_target_A_lbf = sim_config.target_A_lbs;
            end

            if sim_config.target_B_lbs
                vehicle.coastdown_target_B_lbfpmph = sim_config.target_B_lbs;
            end

            if sim_config.target_C_lbs
                vehicle.coastdown_target_C_lbfpmph2 = sim_config.target_C_lbs;
            end

            if sim_config.target_A_N
                vehicle.coastdown_target_A_N = sim_config.target_A_N;
            end

            if sim_config.target_B_N
                vehicle.coastdown_target_B_Npms = sim_config.target_B_N;
            end

            if sim_config.target_C_N
                vehicle.coastdown_target_C_Npms2 = sim_config.target_C_N;
            end
   

            vehicle.coastdown_target_A_N = vehicle.coastdown_target_A_N * sim_config.roadload_multiplier;
            vehicle.coastdown_target_B_Npms = vehicle.coastdown_target_B_Npms * sim_config.roadload_multiplier;
            vehicle.coastdown_target_C_Npms2 = vehicle.coastdown_target_C_Npms2 * sim_config.roadload_multiplier;
 
            
            %% dyno sets
            if sim_config.dyno_set_A_lbs
                vehicle.dyno_set_A_lbf = sim_config.dyno_set_A_lbs;
            end

            if sim_config.dyno_set_B_lbs
                vehicle.dyno_set_B_lbfpmph = sim_config.dyno_set_B_lbs;
            end

            if sim_config.dyno_set_C_lbs
                vehicle.dyno_set_C_lbfpmph2 = sim_config.dyno_set_C_lbs;
            end

            if sim_config.dyno_set_A_N
                vehicle.dyno_set_A_N = sim_config.dyno_set_A_N;
            end

            if sim_config.dyno_set_B_N
                vehicle.dyno_set_B_Npms = sim_config.dyno_set_B_N;
            end

            if sim_config.dyno_set_C_N
                vehicle.dyno_set_C_Npms2 = sim_config.dyno_set_C_N;
            end

            if sim_config.calc_ABC_adjust
                % calculate roadload adjustment from targets and dyno sets
                vehicle = vehicle.calc_roadload_adjust();
            else
                %% roadload adjustment
                if sim_config.adjust_A_lbs
                    vehicle.coastdown_adjust_A_lbf = sim_config.adjust_A_lbs;
                end

                if sim_config.adjust_B_lbs
                    vehicle.coastdown_adjust_B_lbfpmph = sim_config.adjust_B_lbs;
                end

                if sim_config.adjust_C_lbs
                    vehicle.coastdown_adjust_C_lbfpmph2 = sim_config.adjust_C_lbs;
                end

                if sim_config.adjust_A_N
                    vehicle.coastdown_adjust_A_N = sim_config.adjust_A_N;
                end

                if sim_config.adjust_B_N
                    vehicle.coastdown_adjust_B_Npms = sim_config.adjust_B_N;
                end

                if sim_config.adjust_C_N
                    vehicle.coastdown_adjust_C_Npms2 = sim_config.adjust_C_N;
                end
            end
            
            %% test weight/mass
            if sim_config.ETW_lbs
                vehicle.ETW_lbs = sim_config.ETW_lbs;
            end

            if sim_config.ETW_kg
                vehicle.ETW_kg  = sim_config.ETW_kg;
            end

            if sim_config.vehicle_lbs
                vehicle.mass_static_kg  = unit_convert.lbm2kg * sim_config.vehicle_lbs;
            end

            if sim_config.vehicle_kg
                vehicle.mass_static_kg  = sim_config.vehicle_kg;
            end

%             if sim_config.mass_multiplier
%                 vehicle.mass_static_kg  = vehicle.mass_static_kg * sim_config.mass_multiplier;
%                 vehicle.mass_dynamic_kg = vehicle.mass_dynamic_kg * sim_config.mass_multiplier;
%             end

            %% performance weight penalty
            if sim_config.performance_mass_penalty_kg
                temp.perf_phase_num = find(contains(lower(drive_cycle.phase_name),'performance'),1);

                if ~isempty(temp.perf_phase_num)
                    temp.perf_phase_start = drive_cycle.phase_time(drive_cycle.phase == temp.perf_phase_num);

                    % should set penalty back to zero after performance cycle... in
                    % case it's not the last part of the cycle...
                    vehicle.delta_mass_static_kg.axis_1.signal      = 'cycle_pos_secs';
                    vehicle.delta_mass_static_kg.axis_1.breakpoints = [temp.perf_phase_start, temp.perf_phase_start + .001 ];
                    vehicle.delta_mass_static_kg.table              = [0, sim_config.performance_mass_penalty_kg];

                    vehicle.delta_mass_dynamic_kg.axis_1.signal      = 'cycle_pos_secs';
                    vehicle.delta_mass_dynamic_kg.axis_1.breakpoints = [temp.perf_phase_start, temp.perf_phase_start + .001 ];
                    vehicle.delta_mass_dynamic_kg.table              = [0, sim_config.performance_mass_penalty_kg];
                end

                clear temp
            end

            %% final drive ratio (absolute)
            if sim_config.FDR
                vehicle.drive_axle1.final_drive.gear_ratio = sim_config.FDR;
            end

            %% final drive ratio efficiency
            if sim_config.FDR_efficiency_norm
                vehicle.drive_axle1.final_drive.efficiency_norm = sim_config.FDR_efficiency_norm;
            end

            %% start stop
            if sim_config.start_stop
                controls.start_stop_enable = sim_config.start_stop;
            end
                        
%             vars = who;
%             
%             for v = 1:length(vars)
%                 workspace.(vars{v}) = eval(vars{v});
%             end
            
            workspace.ambient = ambient;
            workspace.engine = engine;
            workspace.transmission = transmission;        
            workspace.accessories = accessories;
            workspace.vehicle = vehicle;            
            workspace.controls = controls;
            workspace.electric = electric;
            workspace.driver = driver;
            workspace.drive_cycle = drive_cycle;
        
        end
        
    end
    
    
end

