classdef class_REVS_default_cycle_aggregator < class_REVS_cycle_aggregator
    %UNTITLED2 Summary of this class goes here
    %   Detailed explanation goes here
    
    properties
        
    end
    
    methods
        function obj = class_REVS_default_cycle_aggregator(data, data_root, phase_idx)
            obj@class_REVS_cycle_aggregator(data, data_root, phase_idx);
        end
        
        
        function val = initial(obj, prop)
            val = obj.phase_data.(prop)(obj.phase_idx(1));           
        end
        
        function val = final(obj, prop)
            val = obj.phase_data.(prop)(obj.phase_idx(1));           
        end
        
        function val = maximum(obj, prop)
            val = max(obj.phase_data.(prop)(obj.phase_idx));           
        end
        
        function val = minimum(obj, prop)
            val = min(obj.phase_data.(prop)(obj.phase_idx));           
        end
        
        function val = sum(obj, prop)
            val = sum(obj.phase_data.(prop)(obj.phase_idx));           
        end
        
        function val = mean(obj, prop)
            val = sum(obj.phase_data.(prop)(obj.phase_idx) .* obj.phase_data_root.time_secs(obj.phase_idx)) ./ sum(obj.phase_data_root.time_secs(obj.phase_idx));           
        end
        
        function val = quant_per_dist(obj, prop)
            val = sum(obj.phase_data.(prop)(obj.phase_idx) .* obj.phase_data_root.distance_m(obj.phase_idx)) ./ sum(obj.phase_data_root.distance_m(obj.phase_idx));
        end
        
        function val = dist_per_quant(obj, prop)
            val = sum(obj.phase_data_root.distance_m(obj.phase_idx)) /sum(1./obj.phase_data.(prop)(obj.phase_idx) .* obj.phase_data_root.distance_m(obj.phase_idx));
        end
                
    end
    
end

