classdef class_REVS_drive_cycle
	%class_REVS_drive_cycle
	%   Definition of class_REVS_drive_cycle class
	
	properties
		
		name = '';		
		sample_start_enable = false;
		
		phase_name string	
		phase double {isvector}
		phase_time double {isvector}
		
		cycle_time double {isvector}
		cycle_speed_mps double {isvector}
		
		in_gear double {isvector}
        in_gear_time double {isvector}
        
		ignition double {isvector}
        ignition_time double {isvector}
        
        grade_dist_m double {isvector}
        grade_pct double {isvector}
        				
    end
    
    properties (Hidden)
       
        subcycles (:,1) struct
        
    end
    
    properties (Dependent )
        
        cfr_max_speed_mps
        cfr_min_speed_mps 
        
    end
	
	
	methods
		
	
		function val = get.phase_name(obj)
			
			if ~isempty( obj.phase_name)
				val =  obj.phase_name;
            elseif isempty(obj.phase)
                val = {};
            else
				phase_str = strtrim(cellstr(int2str((1:max(obj.phase))')));				
				val  = phase_str';				
			end
			
        end
        
        function val = get.cfr_max_speed_mps(obj)
            
            t = obj.cycle_time;
            v = obj.cycle_speed_mps;
            v_hi = zeros(size(v));
            for i =1:1:numel(t)
                idx0 = find(t > t(i) -1 , 1);
                idxf = find(t > t(i) +1 , 1);
                if isempty(idxf)
                idxf = idx0;
                end
                v_hi(i) = max(v(idx0:idxf)) + 0.89408;

            end
            v_hi(v_hi <0.89408) = 0;
            val = v_hi;
        end
        
        function val = get.cfr_min_speed_mps(obj)
            
            t = obj.cycle_time;
            v = obj.cycle_speed_mps;
            v_lo = zeros(size(v));
            for i =1:1:numel(t)
                idx0 = find(t > t(i) -1 , 1);
                idxf = find(t > t(i) +1 , 1);
             	if isempty(idxf)
                    idxf = idx0;
                end
                v_lo(i) = min(v(idx0:idxf)) - 0.89408;

            end
            v_lo(v_lo <0) = 0;
            val = v_lo;
        
        end
        
        
        function val = get.subcycles(obj)
            
           if ~isempty(obj.subcycles)
               val = obj.subcycles;
           else
               val = struct('cycle', obj.name, 'phases', unique( obj.phase( obj.phase > 0 ) ) );
           end
            
            
        end
              
				
	end
	
end

