classdef class_REVS_driver 
	%class_REVS_driver
	%   Definition of class_REVS_driver class
	
	properties
        variant = 'default driver';  % name of library driver variant target block
		 
        Kp                                  = 1.0;  % driver PID proportional gain
        Ki                                  = 3.0;  % driver PID integral gain
        Kd                                  = 0.0;  % driver PID derivative gain

        proportional_fade_in_secs           = 1.0;  % Proportional fade [s]
        proportional_fade_in_min_speed_mps  = 2.0;  % Proportional fade [m/s]
		
        lookahead_secs                      = 0.25; % Lookahead [s]
		launch_anticipate_secs              = 0.50; % Launch anticipation [s]
		dynamic_gain_lookahead_secs         = 3.75; % Lookahead [s] for dynamic gain
        
		distance_compensate_enable          = false;    % Distance compensation enable
        late_braking                        = false;    % enables slight overshoot on back side of hills

        human_mode_enable                   = false;
        
		brake_gain_norm                     = 0.13;     % 0.13 = REVS1 compatible brake gains
        
%        accel_pedal_response_norm           = [0.125, 0.2, 0.5, 4.0];   % Accelerator pedal response
%        accel_pedal_response_speed_mps      = [0.0, 5.0, 10 , 75 ];     % Accelerator pedal response speed [m/s] 
        
        accel_pedal_response_speed_mps = [0       5  20  70];
        accel_pedal_response_norm      = [0.125 0.2 1.0 1.0];
    end
	 
end
 