classdef class_REVS_electric
	%REVS_ALPHA_electric
	%   ALPHA Electric description class. Contains definitions for
	%	starter, alternator, batteries and DCDC converter
	
	properties
        name = '';
        
        matrix_vintage    = enum_matrix_vintage.present      
		starter           = class_REVS_starter		
        alternator        = class_REVS_alternator		
        low_voltage_DCDC  = class_REVS_DCDC_converter
        high_voltage_DCDC = class_REVS_DCDC_converter
        
        battery class_REVS_battery              % starter / accessory battery (for CVM)
        
        accessory_battery class_REVS_battery  	% accessory battery (for xEV)
        propulsion_battery class_REVS_battery   % propulsion battery (for xEV)
        
        P0_MG class_REVS_emachine_geared;      % motor / generator (for BAS/ISG hybrids)
        drive_motor class_REVS_emachine;        % drive motor (for xEV)
        
        MG1 class_REVS_emachine_geared;         % generator / motor (for powersplit hybrids)
        MG2 class_REVS_emachine_geared;         % motor / generator (for powersplit hybrids)
	end
	
	methods
		
		function obj = class_REVS_electric( engine )
			% Pass in Engine class to auto calculate starter & alternator
			% parameters
			
			if nargin > 0
				obj.starter = class_REVS_starter( engine );
				obj.alternator = class_REVS_alternator( engine );
            else
                obj.starter = class_REVS_starter;
                obj.alternator = class_REVS_alternator;
            end									            
		end
				
	end
	
end

