classdef class_REVS_final_drive
	%class_REVS_final_drive
	%   Definition of class_REVS_final_drive class
	%
	%
	
	properties
		
		gear_ratio;																	% Axle Gear Ratio
		efficiency_norm = class_REVS_dynamic_lookup;								% Efficiency - dynamic lookup
		input_torque_loss_Nm class_REVS_dynamic_lookup = class_REVS_dynamic_lookup;	% Torque Loss at input - dynamic lookup
		
		inertia_kgm2 = 0.0															% Rotational inertia [kg*m^2]
		
	end
	
	methods
		
		function obj = set.efficiency_norm(obj,val)
			% Allow auto configuration when specifying single efficiency
			if isnumeric(val) && isscalar(val)
				lu = class_REVS_dynamic_lookup;
				lu.axis_1.signal = 'veh_spd_mps';
				lu.axis_1.breakpoints = [0,100];
				lu.table = [val, val];
				obj.efficiency_norm = lu;
			elseif isa( val, 'class_REVS_dynamic_lookup')
				obj.efficiency_norm = val;
			else
				error('While setting property ''efficiency_norm'' of class ''class_REVS_final_drive'':\nValue must be ''class_REVS_dynamic_lookup''.')
			end
		end
				
		function val = get.efficiency_norm( obj)
			if isempty(obj.efficiency_norm)
				obj.efficiency_norm.axis_1.signal = 'veh_spd_mps';
				obj.efficiency_norm.axis_1.breakpoints = [0,100];
				obj.efficiency_norm.table = [1,1];
			end
			
			val = obj.efficiency_norm;
		end
		
		function val = get.input_torque_loss_Nm( obj)
			if isempty(obj.input_torque_loss_Nm)
				obj.input_torque_loss_Nm.axis_1.signal = 'veh_spd_mps';
				obj.input_torque_loss_Nm.axis_1.breakpoints = [0,100];
				obj.input_torque_loss_Nm.table = [0,0];
			end
			
			val = obj.input_torque_loss_Nm;
		end
		
		
	end
	
end

