classdef class_REVS_logging_config < handle & matlab.mixin.Copyable
	%class_REVS_logging_config
	%   Definition of class_REVS_logging_config class
    
    properties
        audit_phase logical = false;
        audit_total logical = false;
        
        datalog_list     = {};
        result_list      = {};
        package_list     = {};
        postprocess_list = {};
        
        get_datalog      = {};
        get_result       = {};                
    end
    
    methods
        
        function obj = class_REVS_logging_config(log_def)
            obj.add_log(REVS_log_default);
            
            if nargin > 0
                obj.add_log(log_def);
            end
        end
        
        %% ---------------------------------------------------------------
        function [] = run_postprocess_scripts(obj)
            for i = 1:length(obj.postprocess_list)
                try
                    fprintf('Running %s\n', obj.postprocess_list{i});
                    evalin('caller', obj.postprocess_list{i});
                catch ME
                    warning('Error postprocessing "%s" (line %d): %s',obj.postprocess_list{i},ME.stack(1).line, ME.message);
                end
            end
        end
        
        function [package_found] = has_package(obj, package_str)
            package_found = (sum(ismember(obj.package_list, package_str)) > 0);
        end
        
        function [] = add_log(obj, log_def)
            
            % THIS DOESN'T WORK... needs to take cell array of strings and
            % make vector of class_REVS_log_packages...
            if ~isa(log_def,'class_REVS_log_package')    % convert str or cellstr to struct
                log_package = class_REVS_log_package;
                log_package.log_list = log_def;
                if ~iscell(log_package.log_list)
                    log_package.log_list = {log_package.log_list};
                end
            else
                log_package = log_def;
            end
            
            for i = 1:length(log_package)
                if isrow(log_package(i).log_list)
                    log_package(i).log_list = log_package(i).log_list'; %#ok<AGROW>
                end
                
                obj.package_list     = unique([obj.package_list; log_package(i).package_list]);
                obj.postprocess_list = unique([obj.postprocess_list; log_package(i).postprocess_list]);
                                
                if isempty(obj.datalog_list)
                    obj.datalog_list = unique(log_package(i).log_list(contains(log_package(i).log_list,'datalog.')));
                else
                    obj.datalog_list = unique([obj.datalog_list; log_package(i).log_list(contains(log_package(i).log_list,'datalog.'))]);
                end
                
                if isempty(obj.result_list)
                    obj.result_list = unique(log_package(i).log_list(contains(log_package(i).log_list,'result.')));
                else
                    obj.result_list  = unique([obj.result_list; log_package(i).log_list(contains(log_package(i).log_list,'result.'))]);
                end
                
                obj.set_datalog_selection_list(strrep(log_package(i).log_list(contains(log_package(i).log_list,'datalog.')),'datalog.',''));
                obj.set_result_selection_list(strrep(log_package(i).log_list(contains(log_package(i).log_list,'result.')),'result.',''));
            end
        end
        
        %% ---------------------------------------------------------------
        function [] = set_datalog_selection_list(obj, datalog_list)
            if ~isempty( datalog_list )
                sigs = reshape(datalog_list, numel(datalog_list), 1);
                sigs{end+1,:} = 'time';
                sigs = strrep(sigs,'.','__');
                sigs = regexptranslate('wildcard',unique(sigs));
                obj.get_datalog = unique([obj.get_datalog; strcat('^',sigs,'$')]);
            end
        end
        
        %% ---------------------------------------------------------------
        function [] = set_result_selection_list(obj, result_list)
            if ~isempty( result_list ) % get_result_selection_list??
                sigs = reshape(result_list, numel(result_list), 1);
                sigs = strrep(sigs,'.','__');
                sigs = regexptranslate('wildcard',unique(sigs));
                obj.get_result = unique([obj.get_result; strcat('^',sigs,'$')]);
            end
        end
        
        %% ---------------------------------------------------------------
        function t = audit_type(obj)
            if obj.audit_phase
                t = 2;
            elseif obj.audit_total
                t = 1;
            else
                t = 0;
            end
        end
        
    end
    
end

