classdef class_REVS_motor_generator
	% class_REVS_motor_generator
	%   ALPHA Electric description class. Contains definitions for
	%	a geared motor/generator (as in a BAS or ISG system)
	
	properties		
        emachine = class_REVS_emachine;     % emachine Definition
        gear     = class_REVS_simple_gear; 	% Gearbox Definition
	end
	
	methods
		
		function obj = class_REVS_electric( engine )
			% Pass in Engine class to auto calculate starter & alternator
			% parameters
			
			if nargin > 0
				obj.starter    = class_REVS_starter( engine );
				obj.alternator = class_REVS_alternator( engine );
            else
                obj.starter    = class_REVS_starter;
                obj.alternator = class_REVS_alternator;
            end

		end
				
	end
	
end

