classdef class_REVS_planetary
    %REVS_planetary
    %   REVS planetary class definition
    
    properties
        R = 1;                       % diameter/radius or number of ring teeth
        S = 1;                       % diameter/radius or number of sun teeth
        
        inertia_sun_kgm2 = 0;        % Planetary Sun Inertia [kg m^2]
        inertia_carrier_kgm2 = 0;    % Planetary Carrier Inertia [kg m^2]
%        inertia_planets_kgm2 = 0;   % Planet Inertia [kg m^2] [NOT IMPLEMENTED AT THIS TIME]
        inertia_ring_kgm2 = 0;       % Planetary Ring Inertia [kg m^2]
        
        mesh_efficiency_norm = 0.99; % nominal efficiency norm per mesh
        
    end
    
    properties ( Dependent )        
    end
    
    methods
        
        function val = R_S_ratio(obj)
           val = - obj.S / obj.R; 
        end
        
        function val = S_R_ratio(obj)
           val = - obj.R / obj.S; 
        end
        
        function val = R_C_ratio(obj)
           val = (1 + obj.R / obj.S) ./ (obj.R / obj.S); 
        end
        
        function val = C_R_ratio(obj)
           val = (obj.R / obj.S) ./ (1 + obj.R / obj.S); 
        end
        
        function val = S_C_ratio(obj)
           val = 1 + obj.R / obj.S; 
        end
        
        function val = C_S_ratio(obj)
           val = 1 ./ (1 + obj.R / obj.S); 
        end
        
        
    end
    
end

