classdef class_REVS_sim_config_key
    %CLASS_REVS_SIM_CONFIG_KEY Summary of this class goes here
    %   Detailed explanation goes here
    
    properties
        key         char
        default
        description char
        eval        logical
        tag         char  
        provided_by char
    end
    
    methods
        function obj = class_REVS_sim_config_key(key, varargin)

            p = inputParser;
            p.addRequired('key',@isvarname);
            p.addParameter('default',[]);
            p.addParameter('description', '');
            %p.addParameter('expand', true, @(x) islogical(x) || isnumeric(x));
            %p.addParameter('aggregate',false, @(x) islogical(x) || isnumeric(x));
            p.addParameter('eval',true, @(x) islogical(x) || isnumeric(x));
            p.addParameter('tag','', @isvarname );
            
            p.parse( key, varargin{:});
                
            fn = fieldnames(p.Results);
            for f = 1:length(fn)
                obj.(fn{f}) = p.Results.(fn{f});
            end
            
            stack = dbstack;
            
                        
            if numel(stack) < 2
                % Nothin
            elseif strcmpi(stack(2).name, 'class_REVS_sim_batch.class_REVS_sim_batch')
                obj.provided_by = 'class_REVS_sim_batch';
            elseif strcmpi(stack(2).name, 'class_REVS_sim_batch.add_key') && numel(stack) >= 3    
                obj.provided_by = stack(3).name;
            else    
                obj.provided_by = stack(2).name;
            end
                           
        end
        

    end
end

