classdef class_REVS_tableshift
	%class_REVS_tableshift
	%   Definition of class_REVS_tableshift class
    
	properties (Constant = true )
       type =  enum_transmission_gear_select.tableshift;
    end
	
    properties
        variant = 'table gear select'; % name of library gear select variant target block
        
        
        % Define Transmission Shifting Schedule
        shift_speed_source = enum_speed_source.gearbox_output_rpm;
        shift_load_source = enum_load_source.engine_load_norm;  
        
        % ... upshifting schedule (transmission output speed in RPM)
        upshift_map_load = [];
        upshift_map_speed   = [];  

        % ... downshifting schedule (transmission output speed in RPM)
        downshift_map_load = [];
        downshift_map_speed = []; 
        
        upshift_delay_secs    = [];     % Upshift delay [s]
        downshift_delay_secs  = [];     % Downshift delay [s]
        upshift_commit_secs =   [];     % Minimum wait to downshift after upshift [s]
    
        upshift_skip_load = [];         % Load above which to do a double upshift
        downshift_skip_load = [];       % Load above which to do a double downshift
        
        
	end
        
    methods
	
        function obj = tableshift( num_gears )
            
           if nargin >= 1 
				
				obj.upshift_delay_secs          = 0.1 * ones(num_gears + 1, 1);
				obj.upshift_commit_secs         = 3.0 * ones(num_gears + 1, 1);

                obj.downshift_delay_secs        = 0.1 * ones(num_gears + 1, 1);
                
                obj.upshift_skip_load           = Inf(num_gears + 1, 1);        
                obj.downshift_skip_load         = Inf(num_gears + 1, 1);  
                
           end
            
        end
		
	end

	
    
end

