classdef class_REVS_transmission
	%class_REVS_transmission 
	%	Base transmission class on which other transmissions are built
	
	properties
		
		name                = '';                           % Description of transmission
        variant             = '';
        matrix_vintage      = enum_matrix_vintage.present;	% Vintage tag of transmission for batch simulation comparison
        type                = enum_transmission_type.no_transmission;
        
        rated_torque_Nm     = 0;                            % Transmission rated input torque [Nm]
		speed_range_radps	= [nan, nan];					% Transmission nominal speed range (engine idle -> max) [radps]
		upstream_inertia_kgm2 = 0;							% Estimated Upstream Inertia (for scaling transmission components) [kg*m^2]
							
	end
	
	methods
		
		function obj = class_REVS_transmission( engine )
			
			if nargin > 0
				
                % Nominal maximum torque
				obj.rated_torque_Nm = engine.max_torque_Nm * 1.15;
				
				% Nominal speed range - idle to max test speed
				obj.speed_range_radps = [engine.nominal_idle_speed_radps, engine.max_test_speed_radps ];
				
				% Upstream inertia
				obj.upstream_inertia_kgm2 = engine.inertia_kgm2;
				
			end
			
		end
		
	end
end

