classdef class_REVS_uber_dynamic_lockup
    %class_REVS_uber_dynamic_lockup
    %   Definition of class_REVS_uber_dynamic_lockup class
        
    properties
        variant = 'lockup rules uber' % name of library lockup select variant target block
        
        lock_table class_REVS_dynamic_lookup;
        unlock_table class_REVS_dynamic_lookup;
        slip_table class_REVS_dynamic_lookup;
        
        downshift_unlock_condition = [];
        upshift_unlock_condition   = [];
        
        always_unlock_gear = 0;
        always_lock_gear = inf;
        
        lock_condition	 = '(@gb_spd_in_radps > @table_lock_spd)';
        unlock_condition = '(@gb_spd_in_radps < @table_unlock_spd)';
        
        lockup_delay_secs = 0.1;    % Lockup delay [s]
        lockup_allowed = true;
        tipout_lockup_allowed = true;
    end
    
    
    methods
        
        function  obj = class_REVS_uber_dynamic_lockup( num_gears, speed_signal )
            
            obj.lock_table   = class_REVS_dynamic_lookup;
            obj.unlock_table = class_REVS_dynamic_lookup;
            obj.slip_table   = class_REVS_dynamic_lookup;
            
            obj.slip_table.axis_1.signal      = 'veh_spd_mps';
            obj.slip_table.axis_1.breakpoints = [0 1];
            obj.slip_table.table              = [0 0];
            
            
            if nargin >= 1
                
                obj.lock_table.axis_1.signal      = 'veh_spd_mps';
                obj.lock_table.axis_1.breakpoints = 0:num_gears;
                obj.lock_table.table              = (0:num_gears > 0) * 1e6;
                
                obj.unlock_table.axis_1.signal      = 'veh_spd_mps';
                obj.unlock_table.axis_1.breakpoints = 0:num_gears;
                obj.unlock_table.table              = (0:num_gears > 0) * 1e6;
                               
            end
            
            if nargin >= 2               
                obj.lock_condition	 = ['(@', speed_signal ' > @table_lock_spd)'];
                obj.unlock_condition = ['(@', speed_signal ' < @table_unlock_spd)'];
            end
            
        end
                        
    end
    
end

