classdef enum_energy_storage_type < Simulink.IntEnumType
	%enum_energy_storage_type
	%   Definition of enum_energy_storage_type class    
    
    enumeration
        conventional(0) % 12V battery only
        HV_DCDC_LV(1)   % high voltage battery with DCDC and 12V battery
        HV_DCDC(2)      % high voltage battery with DCDC direct to accessories
	end
    
	
	methods

		function val = is_conventional(obj)
			val = (obj == enum_energy_storage_type.conventional);
        end

		function val = is_xEV(obj)
			val = (obj == enum_energy_storage_type.xEV) || (obj == enum_energy_storage_type.xEV_no_accessory_batt);
		end

	end

end
