classdef enum_powertrain_type < Simulink.IntEnumType
    %enum_powertrain_type
    %   Definition of enum_powertrain_type class
    
    enumeration
        no_powertrain(-1)
        conventional(0)
        hybrid_P2(1)                % like Jetta Hybrid
        hybrid_P2_BAS(2)            % like Sonata Hybrid
        hybrid_powersplit(3)        % like GEN1..3 Prius
        hybrid_P0(8)                % like Malibu Eco
        battery_electric(7)         % like Tesla S
    end
    
    methods
        
        function val = is_conventional(obj)
            val = (obj == enum_powertrain_type.conventional) ;
        end
        
        function val = is_hybrid(obj)
            val = (obj == enum_powertrain_type.hybrid_P2_BAS) || ...
                (obj == enum_powertrain_type.hybrid_powersplit) || ...
                (obj == enum_powertrain_type.hybrid_P0);
        end

        function val = is_PS(obj)
            val = (obj == enum_powertrain_type.hybrid_powersplit);
        end

        function val = is_P0(obj)
            val = (obj == enum_powertrain_type.hybrid_P0) || (obj == enum_powertrain_type.hybrid_P2_BAS);
        end
        
        function val = is_P2(obj)
            val = (obj == enum_powertrain_type.hybrid_P2) || (obj == enum_powertrain_type.hybrid_P2_BAS);
        end
        
        function val = is_P2_BAS(obj)
            val = (obj == enum_powertrain_type.hybrid_P2_BAS);
        end
        
        function val = is_bev(obj)
            val = (obj == enum_powertrain_type.battery_electric) ;
        end
        
        function val = has_engine(obj)
            val = obj.is_conventional || obj.is_hybrid;
        end
        
        function val = is_electrified(obj)
           val = obj.is_hybrid || obj.is_bev; 
        end
        
    end
    
end
