classdef enum_starter_generator_type < Simulink.IntEnumType 
	%enum_starter_generator_type
	%   Definition of enum_starter_generator_type class
	
    enumeration
        conventional(0)     % 12V starter / alternator
        mild_hybrid(1)      % high voltage motor / generator, as in BAS or ISG system
        strong_hybrid(2)    % starting / charging handled by driveline motors (no starter/generator)
	end
    
	
	methods

		function val = is_conventional(obj)
			val = (obj == enum_starter_generator_type.conventional);
        end

		function val = is_motor_generator(obj)
			val = (obj == enum_starter_generator_type.motor_generator);
        end

		function val = is_full_hybrid(obj)
			val = (obj == enum_starter_generator_type.full_hybrid);
		end
        
	end

end
