function [dc_struct] = ALPHAshift_decode_disability( dc )
% function [dc_struct] = ALPHAshift_decode_disability( dc )
%
%   Parse ALPHAShift disability codes
%
%   Example
%       dc = ALPHAshift_decode_disability(datalog.transmission.ALPHAshift.disability_code);
%
% see also ALPHAshift_plot_disability

dc_struct.insufficient_power = (dc >= 4096);
dc = mod(dc, 4096);

dc_struct.higher_gear = (dc >= 2048);
dc = mod(dc, 2048);

dc_struct.kickdown_min_gear = (dc >= 1024);
dc = mod(dc, 1024);

dc_struct.kickdown_max_increment = (dc >= 512);
dc = mod(dc, 512);

dc_struct.no_torque_avail = (dc >= 256);
dc = mod(dc, 256);

dc_struct.shift_parity = (dc >= 128);
dc = mod(dc, 128);

dc_struct.skip_shift = (dc >= 64);
dc = mod(dc, 64);

dc_struct.downshift_max_speed = (dc >= 32);
dc = mod(dc, 32);

dc_struct.upshift_torque_reserve = (dc >= 16);
dc = mod(dc, 16);

dc_struct.upshift_min_speed = (dc >= 8);
dc = mod(dc, 8);

dc_struct.available_torque = (dc >= 4);
dc = mod(dc, 4);

dc_struct.max_speed = (dc >= 2);
dc = mod(dc, 2);

dc_struct.min_speed = (dc >= 1);

end
