function [] = ALPHAshift_plot_disability(dc_struct, time, plotname)
% function [] = ALPHAshift_plot_disability(dc_struct, time, plotname)
%
% plot disability codes that have non-zero values
%
% Example
%   kdc = ALPHAshift_decode_disability(datalog.transmission.ALPHAshift.kickdown_disability_code);
%   ALPHAshift_plot_disability(kdc, datalog.time, 'kickdown');
%
% see also ALPHAshift_decode_disability

attrs = fieldnames(dc_struct);
for a = 1:length(attrs)
    if sum(sum(dc_struct.(attrs{a}))) > 0
        disp(attrs{a})
        figure; hold on; grid on;
        for gear_num = 1:size(dc_struct.(attrs{a}),2)-1
            gear_index = gear_num + 1;
            plot(time, dc_struct.(attrs{a})(:, gear_index) + 2*(gear_num), 'DisplayName', string(gear_num))
        end
        ax = gca;
        ax.YLim = [0, size(dc_struct.(attrs{a}),2)*2];
        ax.YTickLabel = cellstr(string(ax.YTick/2));
        xlabel('Time (secs)');
        ylabel('Gear Num');
        title(sprintf('%s %s', plotname, attrs{a}), 'Interpreter', 'None');
    end
end
