function [success] = DOR_time_plot( test_data, model_data, data_descriptor, signal_str, signal_descriptor, varargin)
% varargs:
% model_pts = parse_varargs(varargin,'model_pts',[]);

model_pts = parse_varargs(varargin,'model_pts',[]);

success = DOR_xy_plot( test_data, model_data, data_descriptor, 'time', 'Time (S)', signal_str, signal_descriptor, varargin{:});

if ~isempty(model_pts) && success
    start_time = model_data.time(find(model_pts,1,'first'));
    end_time   = model_data.time(find(model_pts,1,'last'));
    
    xlim([(start_time-.02*end_time) (end_time*1.02)]);
end

end
