function [ ] = REVS_DOR_EVM( test_data, model_data, varargin )
% function [ ] = REVS_DOR_EVM( test_data, model_data )
%   creates a Electric Vehicle Model (EVM) DOR.
%   test_data can be a cell array of class_test_data objects or a single
%   class_test_data object.
%   model_data is intended to be a class_test_data object of model data
%   but could also be any singular class_test_data object.
%
% varargs: SEE REVS_DOR_vehicle and REVS_DOR_electrification and REVS_DOR_accessories

if ~iscell(test_data)
    test_data = {test_data};
end

%% drive cycle and vehicle speed
REVS_DOR_vehicle(test_data, model_data, varargin{:});

REVS_DOR_electrification(test_data, model_data, varargin{:});

REVS_DOR_accessories(test_data, model_data, varargin{:});

end
