function [ ] = REVS_DOR_HVM( test_data, model_data, varargin )
% function [ ] = REVS_DOR_HVM( test_data, model_data )
%   creates a Hybrid Vehicle Model (HVM) DOR.
%   test_data can be a cell array of class_test_data objects or a single
%   class_test_data object.
%   model_data is intended to be a class_test_data object of model data
%   but could also be any singular class_test_data object.
%
% varargs: SEE REVS_DOR_vehicle, REVS_DOR_engine, REVS_DOR_fuel,
% REVS_DOR_transmission, REVS_DOR_electrification, REVS_DOR_accessories

if ~iscell(test_data)
    test_data = {test_data};
end

%%
REVS_DOR_vehicle(test_data, model_data, varargin{:});

REVS_DOR_engine(test_data, model_data, varargin{:});

REVS_DOR_fuel(test_data, model_data, varargin{:});

REVS_DOR_transmission(test_data, model_data, varargin{:});

REVS_DOR_electrification(test_data, model_data, varargin{:});

REVS_DOR_accessories(test_data, model_data, varargin{:});

end
