function [ ] = REVS_DOR_electrification( test_data, model_data, varargin )
% function [ ] = REVS_DOR_electrification( test_data, model_data )
%   creates a Electrification (propulsion battery, emachines, DCDC, etc) DOR.
%   test_data can be a cell array of class_test_data objects or a single
%   class_test_data object.
%   model_data is intended to be a class_test_data object of model data
%   but could also be any singular class_test_data object.
%
% varargs:
% data_descriptor     = parse_varargs(varargin,'descriptor','','string');
% time_range          = parse_varargs(varargin,'time_range',[]);

data_descriptor     = parse_varargs(varargin,'descriptor','','string');
time_range          = parse_varargs(varargin,'time_range',[]);
engine_speed_units  = parse_varargs(varargin,'engine_speed_units','rpm','string');  % use same speed units as engine plots

if isempty(time_range)
    model_pts = [];
    time_range = [model_data.time(1) model_data.time(end)];
else
    model_pts = (model_data.time >= time_range(1)) & (model_data.time <= time_range(end));
end

if ~iscell(test_data)
    test_data = {test_data};
end

if strcmpi(engine_speed_units,'rpm')
    engine_speed_units_label = 'RPM';
else
    engine_speed_units_label = 'rad/s';
end

%% propulsion battery
DOR_time_plot(test_data, model_data, data_descriptor, 'propulsion_battery.terminal_voltage_V',      'Propulsion Battery Voltage', 'model_pts', model_pts);
DOR_time_plot(test_data, model_data, data_descriptor, 'propulsion_battery.terminal_current_A',      'Propulsion Battery Current', 'model_pts', model_pts);
DOR_time_plot(test_data, model_data, data_descriptor, 'propulsion_battery.terminal_power_kW',      'Propulsion Battery Power (kW)', 'model_pts', model_pts);

DOR_time_plot(test_data, model_data, data_descriptor, 'propulsion_battery.state_of_charge_norm',    'Propulsion Battery SoC', 'model_pts', model_pts, 'ylim', [0 1]);
DOR_time_plot(test_data, model_data, data_descriptor, 'propulsion_battery.terminal_energy_kWh',     'Propulsion Battery kWh', 'model_pts', model_pts);

%% emachine
DOR_time_plot(test_data, model_data, data_descriptor, 'emachine.torque_Nm',             'Emachine Torque', 'model_pts', model_pts);
DOR_time_plot(test_data, model_data, data_descriptor, ['emachine.speed_' engine_speed_units], ['Emachine Speed (' engine_speed_units_label ')'], 'model_pts', model_pts);
DOR_time_plot(test_data, model_data, data_descriptor, 'emachine.mechanical_power_kW',   'Emachine Shaft Power (kW)', 'model_pts', model_pts);

DOR_time_plot(test_data, model_data, data_descriptor, 'emachine.voltage_V',             'Emachine Voltage', 'model_pts', model_pts);
DOR_time_plot(test_data, model_data, data_descriptor, 'emachine.current_A',             'Emachine Current', 'model_pts', model_pts);
DOR_time_plot(test_data, model_data, data_descriptor, 'emachine.electrical_power_kW',   'Emachine Electrical Power (kW)', 'model_pts', model_pts);

DOR_time_plot(test_data, model_data, data_descriptor, 'emachine.efficiency_norm',       'Emachine Efficiency Norm', 'model_pts', model_pts, 'ylim', [0 1]);

%% MG1
DOR_time_plot(test_data, model_data, data_descriptor, 'MG1.torque_Nm',             'MG1 Torque', 'model_pts', model_pts);
DOR_time_plot(test_data, model_data, data_descriptor, ['MG1.speed_' engine_speed_units], ['MG1 Speed (' engine_speed_units_label ')'], 'model_pts', model_pts);
DOR_time_plot(test_data, model_data, data_descriptor, 'MG1.mechanical_power_kW',   'MG1 Shaft Power (kW)', 'model_pts', model_pts);

DOR_time_plot(test_data, model_data, data_descriptor, 'MG1.voltage_V',             'MG1 Voltage', 'model_pts', model_pts);
DOR_time_plot(test_data, model_data, data_descriptor, 'MG1.current_A',             'MG1 Current', 'model_pts', model_pts);
DOR_time_plot(test_data, model_data, data_descriptor, 'MG1.electrical_power_kW',   'MG1 Electrical Power (kW)', 'model_pts', model_pts);

DOR_time_plot(test_data, model_data, data_descriptor, 'MG1.efficiency_norm',       'MG1 Efficiency Norm', 'model_pts', model_pts, 'ylim', [0 1]);

%% MG2
DOR_time_plot(test_data, model_data, data_descriptor, 'MG2.torque_Nm',             'MG2 Torque', 'model_pts', model_pts);
DOR_time_plot(test_data, model_data, data_descriptor, ['MG2.speed_' engine_speed_units], ['MG2 Speed (' engine_speed_units_label ')'], 'model_pts', model_pts);
DOR_time_plot(test_data, model_data, data_descriptor, 'MG2.mechanical_power_kW',   'MG2 Shaft Power (kW)', 'model_pts', model_pts);

DOR_time_plot(test_data, model_data, data_descriptor, 'MG2.voltage_V',             'MG2 Voltage', 'model_pts', model_pts);
DOR_time_plot(test_data, model_data, data_descriptor, 'MG2.current_A',             'MG2 Current', 'model_pts', model_pts);
DOR_time_plot(test_data, model_data, data_descriptor, 'MG2.electrical_power_kW',   'MG2 Electrical Power (kW)', 'model_pts', model_pts);

DOR_time_plot(test_data, model_data, data_descriptor, 'MG2.efficiency_norm',       'MG2 Efficiency Norm', 'model_pts', model_pts, 'ylim', [0 1]);

end
