function [ ] = REVS_DOR_engine( test_data, model_data, varargin )
% function [ ] = REVS_DOR_engine( test_data, model_data, varargin )
%   creates an Engine DOR.
%   test_data can be a cell array of class_test_data objects or a single
%   class_test_data object.
%   model_data is intended to be a class_test_data object of model data
%   but could also be any singular class_test_data object.
%
% varargs:
% data_descriptor     = parse_varargs(varargin,'descriptor','','string');
% engine              = parse_varargs(varargin,'engine','');
% time_range          = parse_varargs(varargin,'time_range',[]);
% engine_speed_units  = parse_varargs(varargin,'engine_speed_units','rpm','string');

data_descriptor     = parse_varargs(varargin,'descriptor','','string');
engine              = parse_varargs(varargin,'engine','');
time_range          = parse_varargs(varargin,'time_range',[]);
engine_speed_units  = parse_varargs(varargin,'engine_speed_units','rpm','string');

if strcmpi(engine_speed_units,'rpm')
    engine_speed_units_label = 'RPM';
else
    engine_speed_units_label = 'rad/s';
end

if isempty(time_range)
    model_pts = [];
    time_range = [model_data.time(1) model_data.time(end)];
else
    model_pts = (model_data.time >= time_range(1)) & (model_data.time <= time_range(end));
end

if ~iscell(test_data)
    test_data = {test_data};
end

%% engine operation plot
if isobject(engine)
    for i = 1:length(test_data)
        %        REVS_plot_engine_bsfc(engine,'plot_test_data', test_data{i}, 'title', ['Test Data ' num2str(i)]);
        REVS_plot_engine(engine,'efficiency','heatmap', test_data{i}, 'time_range', time_range, 'title', ['Test Data ' num2str(i)]);
        title('Energy-weighted Engine Operation (test data)');
    end
    %    REVS_plot_engine_bsfc(engine,'plot_test_data', model_data, 'title', 'Model Data', 'time_range', time_range);
    try
        REVS_plot_engine(engine,'efficiency','heatmap', model_data, 'title', 'Model Data', 'time_range', time_range);
        title('Energy-weighted Engine Operation (model)');
    end
end

%% engine speed plot
if DOR_time_plot({}, model_data, data_descriptor, ['transmission.gearbox_input_speed_' engine_speed_units],  '','model_pts', model_pts, 'line_color', 'g')
    legend('model trans. input');
else
    figure;
end
DOR_time_plot(test_data, model_data, data_descriptor, ['engine.speed_' engine_speed_units], ['Engine Speed (' engine_speed_units_label ')'],'model_pts', model_pts, 'no_fig');

%% engine gross torque
DOR_time_plot(test_data, model_data, data_descriptor, 'engine.gross_torque_Nm','Engine Gross Torque','model_pts',model_pts);

%% engine crankshaft torque
DOR_time_plot(test_data, model_data, data_descriptor, 'engine.crankshaft_torque_Nm','Engine Crankshaft Torque','model_pts',model_pts);

%% engine gross power
DOR_time_plot(test_data, model_data, data_descriptor, 'engine.gross_power_kW','Engine Gross Power','model_pts',model_pts);

% %% engine gross work
% DOR_time_plot(test_data, model_data, data_descriptor, 'engine.gross_tot_kWh','Engine Gross Work','model_pts',model_pts);


