function [ ] = REVS_DOR_fuel( test_data, model_data, varargin )
% function [ ] = REVS_DOR_fuel( test_data, model_data )
%   creates a Fuel Consumption DOR.
%   test_data can be a cell array of class_test_data objects or a single
%   class_test_data object.
%   model_data is intended to be a class_test_data object of model data
%   but could also be any singular class_test_data object.
%
% varargs:
% data_descriptor     = parse_varargs(varargin,'descriptor','','string');
% time_range          = parse_varargs(varargin,'time_range',[]);
% fuel_plots          = parse_varargs(varargin,'fuel_plots',false,'toggle');

data_descriptor     = parse_varargs(varargin,'descriptor','','string');
time_range          = parse_varargs(varargin,'time_range',[]);
fuel_plots          = parse_varargs(varargin,'fuel_plots',false,'toggle');

if isempty(time_range)
    model_pts = [];
    time_range = [model_data.time(1) model_data.time(end)];
else
    model_pts = (model_data.time >= time_range(1)) & (model_data.time <= time_range(end));
end

if ~iscell(test_data)
    test_data = {test_data};
end

DOR_time_plot(test_data, model_data, data_descriptor, 'vehicle.fuel_economy_mpg','Fuel Economy (MPG)','model_pts', model_pts);
legend('Location','SouthEast')

if fuel_plots
    %% fuel consumption plot (mass)
    DOR_time_plot(test_data, model_data, data_descriptor, 'vehicle.fuel.mass_g','Fuel Consumed (grams)','model_pts', model_pts);
    legend('Location','NorthWest')
    
    %% fuel consumption plot (volume)
%    DOR_time_plot(test_data, model_data, data_descriptor, 'vehicle.fuel.volume_cc','Fuel Consumed (cc)','model_pts',model_pts);
%    legend('Location','NorthWest')
    
    DOR_time_plot(test_data, model_data, data_descriptor, 'vehicle.fuel.volume_gal','Fuel Consumed (gal)','model_pts', model_pts);
    legend('Location','NorthWest')
    
    %% fuel consumption plot (energy)
    % DOR_time_plot(test_data, model_data, data_descriptor, 'vehicle.fuel.mass_g * test_data{i}.vehicle.fuel.energy_density_MJpkg','Fuel Energy Consumed (kJ)','model_pts',model_pts);
    % legend('Location','NorthWest')
    
    %% fuel consumption plot (cc/sec)
    %DOR_time_plot(test_data, model_data, data_descriptor, 'vehicle.fuel.flow_rate_ccps_filt(1)','Fuel Rate (cc/sec)','model_pts',model_pts);
    
    %DOR_time_plot(test_data, model_data, data_descriptor, 'vehicle.fuel.flow_rate_gps_filt(1)','Fuel Rate (g/sec)','model_pts',model_pts);
    
%    DOR_time_plot(test_data, model_data, data_descriptor, 'vehicle.fuel.flow_rate_ccps','Fuel Rate (cc/sec)','model_pts',model_pts);
    
    DOR_time_plot(test_data, model_data, data_descriptor, 'vehicle.fuel.flow_rate_gps','Fuel Rate (g/sec)','model_pts',model_pts);
end

end
