function [ ] = REVS_DOR_vehicle( test_data, model_data, varargin )
% function [ ] = REVS_DOR_vehicle( test_data, model_data, varargin )
%   creates a Conventional Vehicle Model (CVM) DOR.
%   test_data can be a cell array of class_test_data objects or a single
%   class_test_data object.
%   model_data is intended to be a class_test_data object of model data
%   but could also be any singular class_test_data object.
%
% varargs:
% data_descriptor     = parse_varargs(varargin,'descriptor','','string');
% %time_range         = parse_varargs(varargin,'time_range',[model_data.time(1) model_data.time(end)]);
% time_range          = parse_varargs(varargin,'time_range',[]);
% vehicle_speed_units = parse_varargs(varargin,'vehicle_speed_units','mph','string');

data_descriptor     = parse_varargs(varargin,'descriptor','','string');
time_range          = parse_varargs(varargin,'time_range',[]);
vehicle_speed_units = parse_varargs(varargin,'vehicle_speed_units','mph','string');

if strcmpi(vehicle_speed_units,'mph')
    vehicle_speed_units_label = 'MPH';
else
    vehicle_speed_units_label = 'm/s';
end

if isempty(time_range)
    model_pts = [];
    time_range = [model_data.time(1) model_data.time(end)];
else
    model_pts = (model_data.time >= time_range(1)) & (model_data.time <= time_range(end));
end

if ~iscell(test_data)
    test_data = {test_data};
end

%% drive cycle and vehicle speed
DOR_time_plot({}, model_data, data_descriptor, ['vehicle.drive_cycle_speed_' vehicle_speed_units],'', 'model_pts', model_pts, 'line_color','g');
DOR_time_plot(test_data, model_data, data_descriptor, ['vehicle.speed_' vehicle_speed_units],['Vehicle Speed (' vehicle_speed_units_label ')'],'model_pts', model_pts, 'no_fig');

%xlim([time_range(1)-.02*time_range(2) time_range(2)*1.02]);
legend('drive cycle','model');

%% accel pedal plot
DOR_time_plot(test_data, model_data, data_descriptor, 'vehicle.accel_pedal_pct','Accel Pedal (pct)','model_pts', model_pts);
ylim([0 100]);

%% brake pedal plot
DOR_time_plot(test_data, model_data, data_descriptor, 'vehicle.brake_pedal_pct','Brake Pedal (pct)','model_pts', model_pts);
ylim([0 100]);

%% wheel torque
DOR_time_plot(test_data, model_data, data_descriptor, 'vehicle.wheel_torque_Nm','Vehicle Wheel Torque','model_pts', model_pts);

%% tire speed
DOR_time_plot(test_data, model_data, data_descriptor, 'vehicle.wheel_speed_rpm','Wheel Speed','model_pts', model_pts);

end
