function [ETW_bin] = REVS_calc_ETW_bin(mass_lbs)
% function [ETW_bin] = REVS_calc_ETW_bin(mass_lbs)
%   Calculate Equivalent Test Weight bin, from 40 CFR 1066.805

bin_starts = [   0, 1063, 1188, 1313, 1438, 1563, 1688, 1813, 1938, 2063, 2188, 2313, 2438, 2563, 2688, 2813, 2938, 3063, 3188, 3313, 3438, 3563, 3688, 3813, 3938, 4126, 4376, 4626, 4876, 5126, 5376, 5751, 6251, 6751, 7251, 7751, 8251, 8751, 9251,  9751, 10251, 10751, 11251, 11751, 12251, 12751, 13251, 13751];
bin_values = [1000, 1125, 1250, 1375, 1500, 1625, 1750, 1875, 2000, 2125, 2250, 2375, 2500, 2625, 2750, 2875, 3000, 3125, 3250, 3375, 3500, 3625, 3750, 3875, 4000, 4250, 4500, 4750, 5000, 5250, 5500, 6000, 6500, 7000, 7500, 8000, 8500, 9000, 9500, 10000, 10500, 11000, 11500, 12000, 12500, 13000, 13500, 14000];

if mass_lbs < 0
    ETW_bin = 1000;
elseif mass_lbs >= max(bin_starts)
    ETW_bin = 14000;
else
    ETW_bin = interp1(bin_starts, bin_values, mass_lbs, 'previous');
end

end