function [corrected_torque_Nm, corrected_power_W] = REVS_calc_corrected_torque_and_power(time, audit_torque_Nm, audit_speed_radps, audit_inertia_kgm2, varargin)

    interp_freq_Hz = parse_varargs(varargin,'interp_freq_Hz', 100);

    % create fixed-step time vector for alpha (rad/s) calculation
    if max(diff(time)) - min(diff(time)) > 0.001
		interp_time = linspace(time(1), time(end), time(end)*interp_freq_Hz); 
	else
		interp_time = time;
	end

    interp_speed_radps = interp1(time, audit_speed_radps, interp_time);
    interp_torque_Nm = interp1(time, audit_torque_Nm, interp_time);
    interp_inertia_kgm2 = interp1(time, audit_inertia_kgm2, interp_time);
    alpha_radps2 = delta(interp_speed_radps, 1)./delta(interp_time, 1);
    
    corrected_torque_Nm = interp1(interp_time, interp_torque_Nm - interp_inertia_kgm2 .* alpha_radps2, time);
    corrected_power_W = audit_speed_radps .* corrected_torque_Nm;
end