function [ perf ] = REVS_calc_performance_stats( time, datalog, varargin)
%REVS_calc_performance_stats

start_phase = parse_varargs(varargin,'start_phase', 1,'numeric');

plot_results = parse_varargs( varargin, 'do_plots', false, 'toggle' );

phase = datalog.drive_cycle.phase;
%speed_mps = lowpass_filter(datalog.vehicle.output_spd_mps, time, 1);    %
%seemed to cause NaNs as results, need to check on this...
speed_mps = datalog.vehicle.output_spd_mps;
distance_m = datalog.vehicle.distance_m;

% Phase 1
start_dist_m = distance_m(find(phase == start_phase + 0,1,'first'));
idx_0 =  find(phase == start_phase + 0 & speed_mps <= (0.0 * unit_convert.mph2mps),1,'last');
%idx_0 =  find(phase == start_phase + 0 & (datalog.drive_cycle.spd_mps > 0.0),1,'first');

perf.start_time = time(idx_0);

perf.top_speed_mph = max(datalog.vehicle.output_spd_mps) * unit_convert.mps2mph;

%idx_0 = find(datalog.drive_cycle_phase == start_phase + 0 & (datalog.drive_cycle.spd_mps <= 0.01 * unit_convert.mph2mps), 1,'last');
idx_30 = find(phase ==  start_phase + 0 & speed_mps >= (30.0 * unit_convert.mph2mps),1,'first');
idx_60 = find(phase ==  start_phase + 0 & speed_mps >= (60.0 * unit_convert.mph2mps),1,'first');
idx_qtr_mi = find(phase ==  start_phase + 0 & distance_m - start_dist_m >= (0.25 * unit_convert.mi2mtr),1,'first');
idx_half_mi = find(phase ==  start_phase + 0 & distance_m - start_dist_m >= (0.5 * unit_convert.mi2mtr),1,'first');

idx_30 = idx_30 + [-1,0];
time_30 = interp1(speed_mps(idx_30), time(idx_30), 30 * unit_convert.mph2mps );
perf.zero_to_thirty_time_secs = time_30 - perf.start_time;

idx_60 = idx_60 + [-1,0];
time_60 = interp1(speed_mps(idx_60), time(idx_60), 60 * unit_convert.mph2mps );
perf.zero_to_sixty_time_secs = time_60 - perf.start_time;

if plot_results
    fplothg(time, datalog.vehicle.output_spd_mps * unit_convert.mps2mph);
    plothg(time, datalog.drive_cycle.spd_mps * unit_convert.mps2mph, 'm.-');
    lineat(60 * unit_convert.mps2mph,'g');
    lineat(30,'m');
    lineat(60,'r');
    vlineat(perf.start_time,'g');
    vlineat(time_30,'m');
    vlineat(time_60,'r');
    xlim([perf.start_time-1, time_60+1]);
    ylim([0 65]);
    title('0-30 and 0-60');
end

idx_qtr_mi = idx_qtr_mi + [-1,0];
time_qtr_mi = interp1(distance_m(idx_qtr_mi), time(idx_qtr_mi), start_dist_m + (0.25 * unit_convert.mi2mtr) );
perf.quarter_mile_time_secs = time_qtr_mi - perf.start_time;
perf.quarter_mile_speed_mps = interp1( time, speed_mps, time_qtr_mi);
perf.quarter_mile_speed_mph = perf.quarter_mile_speed_mps * unit_convert.mps2mph;

idx_half_mi = idx_half_mi + [-1,0];
time_half_mi = interp1(distance_m(idx_half_mi), time(idx_half_mi), start_dist_m + (0.50 * unit_convert.mi2mtr) );
perf.half_mile_time_secs = time_half_mi - perf.start_time;
perf.half_mile_speed_mps = datalog.vehicle.output_spd_mps(idx_half_mi(2));
perf.half_mile_speed_mph = perf.half_mile_speed_mps * unit_convert.mps2mph;

accel_mps2 = delta(datalog.vehicle.output_spd_mps, 0) ./ delta(time, 0);

if plot_results
    fplothg(time, accel_mps2);
    lineat(0.001, 'r');
    title('accel_mps2');
end

%Phase 2 (30->50 passing time)
%ref_30 = datalog.vehicle.output_spd_mps(find(datalog.drive_cycle.phase == start_phase + 1,1,'first')) + (0.001*unit_convert.mph2mps);
ref_30 = 30.00 * unit_convert.mph2mps;
%idx_30 = find(phase ==  start_phase + 1 & datalog.vehicle.output_spd_mps <= ref_30,1,'last');
idx_30 = find(phase ==  start_phase + 1 & datalog.vehicle.output_spd_mps >= ref_30 & accel_mps2 >= 0.001,1,'first') - 1;
idx_50 = find(phase ==  start_phase + 1 & datalog.vehicle.output_spd_mps >= (50 * unit_convert.mph2mps),1,'first');

% %idx_30 = idx_30 + [-1,0,1];
% idx_30 = idx_30 + [0,1];
% %time_30 = interp1(speed_mps(idx_30), time(idx_30), ref_30 );
% time_30 = interp1(datalog.drive_cycle.spd_mps(idx_30), time(idx_30), ref_30 );
time_30 = time(idx_30);

idx_50 = idx_50 + [-1,0];
time_50 = interp1(speed_mps(idx_50), time(idx_50), 50 * unit_convert.mph2mps );

perf.thirty_to_fifty_time_secs =  time_50 - time_30;

if plot_results
    fplothg(time, datalog.vehicle.output_spd_mps * unit_convert.mps2mph);
    plothg(time, datalog.drive_cycle.spd_mps * unit_convert.mps2mph, 'm.-');
    lineat(ref_30 * unit_convert.mps2mph,'g');
    lineat(50,'r');
    vlineat(time_30,'g');
    vlineat(time_50,'r');
    xlim([time_30-1 time_50+1]);
    ylim([25 55]);
    title('30-50');
end

% Phase 3 (50->70 passing time)
%ref_50 = datalog.vehicle.output_spd_mps(find(phase == start_phase + 2,1,'first')) + (0.001*unit_convert.mph2mps);
ref_50 = 50.00 * unit_convert.mph2mps;
%idx_50 = find(phase ==  start_phase + 2 & datalog.vehicle.output_spd_mps <= ref_50, 1, 'last');
idx_50 = find(phase == start_phase + 2 & datalog.vehicle.output_spd_mps >= ref_50 & accel_mps2 >= 0.001,1,'first') - 1;
idx_70 = find(phase == start_phase + 2 & datalog.vehicle.output_spd_mps >= (70 * unit_convert.mph2mps), 1, 'first');

% idx_50 = idx_50 + [0,1];
% %time_50 = interp1(speed_mps(idx_50), time(idx_50), ref_50 );
% time_50 = interp1(datalog.drive_cycle.spd_mps(idx_50), time(idx_50), ref_50 );
time_50 = time(idx_50);

idx_70 = idx_70 + [-1,0];

if ~isempty(idx_70)
    
    time_70 = interp1(speed_mps(idx_70), time(idx_70), 70 * unit_convert.mph2mps );

    perf.fifty_to_seventy_time_secs =  time_70 - time_50;
    
else
    
    time_70 = time_50 + 50;
    
    perf.fifty_to_seventy_time_secs = nan;

end

if plot_results
    fplothg(time, datalog.vehicle.output_spd_mps * unit_convert.mps2mph);
    plothg(time, datalog.drive_cycle.spd_mps * unit_convert.mps2mph, 'm.-');
    lineat(ref_50 * unit_convert.mps2mph,'g');
    lineat(70,'r');
    vlineat(time_50,'g');
    vlineat(time_70,'r');
    xlim([time_50-1 time_70+1]);
    ylim([45 75]);
    title('50-70');
end

% Phase 4 (40->60 passing time) if available
if ~isempty(find(phase == start_phase + 3, 1))
    ref_40 = 40.00 * unit_convert.mph2mps;
    idx_40 = find(phase == start_phase + 3 & datalog.vehicle.output_spd_mps >= ref_40 & accel_mps2 >= 0.001,1,'first') - 1;
    idx_60 = find(phase == start_phase + 3 & datalog.vehicle.output_spd_mps >= (60 * unit_convert.mph2mps), 1, 'first');

    time_40 = time(idx_40);

    idx_60 = idx_60 + [-1,0];
else
    idx_60 = [];
end

if ~isempty(idx_60)

    time_60 = interp1(speed_mps(idx_60), time(idx_60), 60 * unit_convert.mph2mps );

    perf.forty_to_sixty_time_secs =  time_60 - time_40;

else

    time_60 = time_60 + 60;

    perf.forty_to_sixty_time_secs = nan;

end

if ~isnan(perf.forty_to_sixty_time_secs) && plot_results
    fplothg(time, datalog.vehicle.output_spd_mps * unit_convert.mps2mph);
    plothg(time, datalog.drive_cycle.spd_mps * unit_convert.mps2mph, 'm.-');
    lineat(ref_40 * unit_convert.mps2mph,'g');
    lineat(60,'r');
    vlineat(time_40,'g');
    vlineat(time_60,'r');
    xlim([time_40-1 time_60+1]);
    ylim([35 65]);
    title('40-60');
end

% if REVS.verbose
% 	fprintf(REVS.output_fid, '\n** Performance Stats ** \n');
% 	fprintf(REVS.output_fid,' 0 to 30 time: %f sec \n', perf.zero_to_thirty_time_secs);
% 	fprintf(REVS.output_fid,' 0 to 60 time: %f sec \n', perf.zero_to_sixty_time_secs);
% 	fprintf(REVS.output_fid,'30 to 50 time: %f sec \n', perf.thirty_to_fifty_time_secs);
%	fprintf(REVS.output_fid,'40 to 60 time: %f sec \n', perf.forty_to_sixty_time_secs);
% 	fprintf(REVS.output_fid,'50 to 70 time: %f sec \n', perf.fifty_to_seventy_time_secs);
% 	fprintf(REVS.output_fid,'1/4 mile time: %f sec @ %f mph\n', perf.quarter_mile_time_secs, perf.quarter_mile_speed_mph );
% 	fprintf(REVS.output_fid,'1/2 mile time: %f sec @ %f mph\n', perf.half_mile_time_secs, perf.half_mile_speed_mph );
%     fprintf(REVS.output_fid,'top speed    : %f mph\n', perf.top_speed_mph);
% 	fprintf(REVS.output_fid,'\n');
% end

