
function [scale_factor, base]  = REVS_calc_vehicle_performance_scale( engine, transmission, vehicle, base_engine, base_transmission, base_vehicle )

vspeed_mps = 1:0.25:70;

redline_radps       = min(base_engine.full_throttle_speed_radps(end) - 650 * unit_convert.rpm2radps, REVS_calc_engine_power_speed(base_engine, 0.98, 'max')) ;
[~, base_wheelpower_W] = REVS_calc_max_wheeltorque( base_engine, base_transmission, base_vehicle.drive_axle1, 'stall_radps', 1 * 3000 * unit_convert.rpm2radps, 'redline_radps', redline_radps , 'max_speed_mph', 70, 'do_plots' );
base_roadload_W		= vspeed_mps .* ( base_vehicle.coastdown_target_A_N + vspeed_mps * base_vehicle.coastdown_target_B_Npms + vspeed_mps .^2 * base_vehicle.coastdown_target_C_Npms2 );
base_boost_ratio    = max(base_engine.full_throttle_torque_Nm)/max(base_engine.naturally_aspirated_torque_Nm)-1;
base.wheel_perf		= sum(base_wheelpower_W * ( 1-base_boost_ratio/20) - base_roadload_W) ;
base.mass_kg		= base_vehicle.mass_dynamic_kg;

redline_radps		= min(engine.full_throttle_speed_radps(end) - 650 * unit_convert.rpm2radps, REVS_calc_engine_power_speed(engine, 0.98, 'max')) ;
[~, wheelpower_W]	= REVS_calc_max_wheeltorque( engine, transmission, vehicle.drive_axle1, 'stall_radps', 1 * 3000 * unit_convert.rpm2radps, 'redline_radps', redline_radps , 'max_speed_mph', 70, 'do_plots' );
roadload_W			= vspeed_mps .* ( vehicle.coastdown_target_A_N + vspeed_mps * vehicle.coastdown_target_B_Npms + vspeed_mps .^2 * vehicle.coastdown_target_C_Npms2 );
boost_ratio			= max(engine.full_throttle_torque_Nm)/max(engine.naturally_aspirated_torque_Nm)-1;
test.wheel_perf			= sum(wheelpower_W * ( 1-boost_ratio/20) - roadload_W);
test.mass_kg				= vehicle.mass_dynamic_kg;

% Scale factor is ratio of wheel powers with an adjustment mass
% The 0.88 is intended to cover rotational inertia that may not be reduced with mass
scale_factor = base.wheel_perf / test.wheel_perf * ( 1 + ( test.mass_kg / base.mass_kg - 1 )* 0.88) ;
