function REVS_check_idle_fuel( engine, idle_speed_radps, idle_brake_torque_Nm )

%TODO: Refactor for standardized fuel map / torque curve access methods

if nargin < 2
    idle_speed_radps = min( engine.idle_speed_radps.table(:) );
end

if nargin < 3
    idle_tc_torque_Nm = ( idle_speed_radps / 260 *sqrt( engine.max_torque_Nm) )^2;
    idle_accy_torque_Nm = 650 / idle_speed_radps;
    idle_brake_torque_Nm = idle_accy_torque_Nm + idle_tc_torque_Nm;
end

idle_fric_torque_Nm = -interp1( engine.closed_throttle_speed_radps, engine.closed_throttle_torque_Nm, idle_speed_radps, 'linear','extrap');
idle_ind_torque_Nm = idle_brake_torque_Nm + idle_fric_torque_Nm;

idle_fuel_gps = interp2( engine.fuel_map_speed_radps, engine.fuel_map_torque_Nm, engine.fuel_map_gps, idle_speed_radps, idle_brake_torque_Nm );
idle_ind_eff = ( idle_ind_torque_Nm * idle_speed_radps  ) / ( idle_fuel_gps * engine.fuel.energy_density_MJpkg *1000 );

ind_eff_limits = [0.27, 0.35];
fuel_gps_limits = ( idle_ind_torque_Nm * idle_speed_radps ) ./ ind_eff_limits ./ engine.fuel.energy_density_MJpkg / 1000;


fprintf('Estimated idle fuel consumption @ %0.0f RPM & %0.1f Nm: %0.3f g/sec => Indicated Efficiency: %0.1f%%\n', idle_speed_radps .* unit_convert.radps2rpm, idle_brake_torque_Nm, idle_fuel_gps, idle_ind_eff * 100)

if idle_fuel_gps < fuel_gps_limits(2)  
    warning('Idle fuel consumption is below expected range [%0.3f - %0.3f]', fuel_gps_limits(2), fuel_gps_limits(1));
elseif idle_fuel_gps > fuel_gps_limits(1)
	warning('Idle fuel consumption is above expected range [%0.3f - %0.3f]', fuel_gps_limits(2), fuel_gps_limits(1));
end

end

