function REVS_compare_engines( engines,metric, compare_type , speeds)
%UNTITLED Summary of this function goes here
%   Detailed explanation goes here

%TODO: validate metric and compare_ttpe


if nargin <4 
    num_plots = 1;
    use_min_bsfc = true;
    speeds = 0;
else
    num_plots = length( speeds );
    use_min_bsfc = false;
end


    
for p = 1:num_plots
   
figure
hold on 
grid on

speed = speeds(p);
legend_list = {};

for e = 1:length(engines)    
    
    legend_list{e} = engines{e}.name;
    
    if  use_min_bsfc
        [data.speed_radps, data.torque_Nm ] = REVS_calc_engine_min_bsfc(engines{e} );
    else
        
        data.torque_Nm = engines{e}.fuel_map_torque_Nm(:) ; 
        wot_torque = interp1(engines{e}.full_throttle_speed_radps, engines{e}.full_throttle_torque_Nm, speed * unit_convert.rpm2radps );
        pts = data.torque_Nm  > 0.05*wot_torque  & data.torque_Nm < wot_torque;
        data.torque_Nm = [0.05* wot_torque; data.torque_Nm(pts); wot_torque];
        
        data.speed_radps = speed * unit_convert.rpm2radps * ones(size(data.torque_Nm ));
    end
        
        
        data.speed_rpm = data.speed_radps * unit_convert.radps2rpm;
        
        data.normalized_torque = data.torque_Nm / max(data.torque_Nm(:)); 
        data.power_kW = data.torque_Nm .* data.speed_rpm / 9549.3;
        data.normalized_power = data.power_kW ./ max( data.power_kW(:));
            

        data.fuel_gps = interp2( engines{e}.fuel_map_speed_radps,   engines{e}.fuel_map_torque_Nm, engines{e}.fuel_map_gps, data.speed_radps, data.torque_Nm);
        
        data.bsfc_gpkWh = data.fuel_gps .* 3600 .* 9549 ./ ( data.speed_rpm .* data.torque_Nm ) ;
        data.efficiency_pct = 100 * ( data.speed_rpm .* data.torque_Nm ) ./( 9549.3 * data.fuel_gps * engines{e}.fuel.energy_density_MJpkg );


        colors = get(0,'DefaultAxesColorOrder');
        line( data.(compare_type), data.(metric), 'Color',colors(e,:),'LineWidth',5);
              
        
end

if use_min_bsfc
    speed_string = 'Minimum BSFC';
else
    speed_string = [int2str(speed),' RPM'];
end



title(['Comparison of Engine ', strrep(metric,'_',' '),' at ', speed_string]);
xlabel(strrep(compare_type,'_',' '));
ylabel(strrep(metric,'_',' '));
legend( legend_list ,'Location','SouthEast');



end



end

