function [ torque_converter ] = REVS_gen_torque_converter( engine, varargin )
%function [ torque_converter ] = REVS_gen_torque_converter(  engine, varargin )
% VARARGS:
% torque_multiplication     = parse_varargs(varargin, 'torque_multiplication', 1.8, 'numeric');
% pump_inertia_kgm2         = parse_varargs(varargin, 'pump_inertia_kgm2', [], 'numeric');
% turbine_inertia_kgm2      = parse_varargs(varargin, 'turbine_inertia_kgm2', [], 'numeric');
% lockup_efficiency         = parse_varargs(varargin, 'lockup_efficiency', 1.0, 'numeric');
% stall_speed_rpm			= parse_varargs(varargin, 'stall_speed_rpm', min(2500, engine.max_test_speed_rpm), 'numeric');
% lockup_duration_secs		= parse_varargs(varargin, 'lockup_duration_secs', 0.3, 'numeric');
% stall_torque_Nm           = parse_varargs(varargin, 'stall_torque_Nm', interp1(engine.full_throttle_speed_radps*unit_convert.radps2rpm, engine.full_throttle_torque_Nm, stall_speed_rpm), 'numeric');
% stall_k_factor_rpmpsqrtNm = parse_varargs(varargin, 'k_factor_rpmpsqrtNm', stall_speed_rpm / sqrt(stall_torque_Nm), 'numeric');

%     lockup_delay_secs     = parse_varargs(varargin, 'lockup_delay_secs', 0.25, 'numeric'); 

torque_multiplication     = parse_varargs(varargin, 'torque_multiplication', 1.8, 'numeric');
pump_inertia_kgm2         = parse_varargs(varargin, 'pump_inertia_kgm2', [], 'numeric');
turbine_inertia_kgm2      = parse_varargs(varargin, 'turbine_inertia_kgm2', [], 'numeric');
lockup_efficiency         = parse_varargs(varargin, 'lockup_efficiency', 1.0, 'numeric');


stall_speed_rpm       = parse_varargs(varargin, 'stall_speed_rpm', min(2500, engine.max_test_speed_rpm), 'numeric');
lockup_duration_secs  = parse_varargs(varargin, 'lockup_duration_secs', 0.3, 'numeric');
% lockup_delay_secs     = parse_varargs(varargin, 'lockup_delay_secs', 0.25, 'numeric');    


stall_torque_Nm           = parse_varargs(varargin, 'stall_torque_Nm', interp1(engine.full_throttle_speed_radps*unit_convert.radps2rpm, engine.full_throttle_torque_Nm, stall_speed_rpm), 'numeric');
stall_k_factor_rpmpsqrtNm = parse_varargs(varargin, 'k_factor_rpmpsqrtNm', stall_speed_rpm / sqrt(stall_torque_Nm), 'numeric');

use_GEM_values			= parse_varargs(varargin, 'use_GEM',false,'toggle');

%%
torque_converter = class_REVS_torque_converter;


% tcc_strategy.lockup_delay_secs         = lockup_delay_secs;
% tcc_strategy.lockup_allowed            = true;

torque_converter.lockup_efficiency_norm = lockup_efficiency;
torque_converter.lockup_duration_secs  = lockup_duration_secs;

if isempty(pump_inertia_kgm2)
    torque_converter.pump_inertia_kgm2    = 2/3 * engine.inertia_kgm2 / 2.5;
end

if isempty(turbine_inertia_kgm2)
    torque_converter.turbine_inertia_kgm2 = 1/3 * engine.inertia_kgm2 / 2.5;
end

%% calc K-factors

if use_GEM_values	
    torque_converter.speed_ratio               = (0:0.01:0.975)';
    torque_converter.drive_torque_ratio        = interp1([0 0.875 1],[1.7 1 1], torque_converter.speed_ratio);
    torque_converter.decel_torque_ratio        = 0.98 * ones(size(torque_converter.speed_ratio));
    torque_converter.drive_k_factor_rpmpsqrtNm = stall_k_factor_rpmpsqrtNm * ((1./(max(0,1-torque_converter.speed_ratio/0.975))).^0.21 - 0.26 * torque_converter.speed_ratio.^1.1);
else
    torque_converter.speed_ratio               = [0;0.1;0.15;0.2;0.25;0.3;0.35;0.4;0.45;0.5;0.55;0.6;0.65;0.7;0.75;0.8;0.85;0.9;0.91;0.92;0.93;0.94;0.95;0.96];
    torque_converter.drive_torque_ratio        = torque_multiplication * [1;0.950276243093923;0.922651933701657;0.900552486187845;0.87292817679558;0.850828729281768;0.823204419889503;0.801104972375691;0.773480662983425;0.751381215469613;0.729281767955801;0.701657458563536;0.679558011049724;0.657458563535912;0.635359116022099;0.607734806629834;0.569060773480663;0.546961325966851;0.546961325966851;0.541436464088398;0.546961325966851;0.552486187845304;0.558011049723757;0.552486187845304];
    torque_converter.decel_torque_ratio        = 0.98 * ones(length(torque_converter.speed_ratio),1);
    torque_converter.drive_k_factor_rpmpsqrtNm = stall_k_factor_rpmpsqrtNm * [1;1.0037242122801;1.00686039104229;1.00529230166119;0.997353849169403;0.97951683245945;0.980888910667908;0.976772676042534;0.965061008477483;0.961777821335816;0.961238790611065;0.96094477385211;0.957661586710443;0.957955603469398;0.963100896751115;0.975400597834077;1.01283873180771;1.12255598569118;1.17685108051159;1.23741853285637;1.31998823932964;1.44058411329446;1.63233204292645;1.88660753662959];
end

torque_converter.decel_k_factor_rpmpsqrtNm = 0.7 * torque_converter.drive_k_factor_rpmpsqrtNm(1) + torque_converter.drive_k_factor_rpmpsqrtNm;

end
