function REVS_plot_battery(b)
% REVS_plot_battery(b)

%%
figure;
subplot(2,1,1);
REVS_plot_dynamic_lookup(b.powerlimit_discharge_map_W, 'title', 'powerlimit_discharge_W');

subplot(2,1,2)
REVS_plot_dynamic_lookup(b.powerlimit_charge_map_W, 'title', 'powerlimit_charge_W');

%%
figure;
subplot(2,1,1);
REVS_plot_dynamic_lookup(b.open_circuit_voltage_map_discharge_V, 'title', 'OC_discharge_V');

subplot(2,1,2)
REVS_plot_dynamic_lookup(b.open_circuit_voltage_map_charge_V, 'title', 'OC_charge_V');

%%
figure;
subplot(2,1,1);
REVS_plot_dynamic_lookup(b.resistance_map_discharge_Ohms, 'title', 'R_discharge_Ohms');

subplot(2,1,2)
REVS_plot_dynamic_lookup(b.resistance_map_charge_Ohms, 'title', 'R_charge_Ohms');

%%
figure;
subplot(2,1,1);
plothg(b.temperature_power_derate_index_temp_degC, b.temperature_power_discharge_derate_norm);
xyt('Temp (degC)','Discharge Derate (norm)');

subplot(2,1,2)
plothg(b.temperature_power_derate_index_temp_degC, b.temperature_power_charge_derate_norm);
xyt('Temp (degC)','Charge Derate (norm)');


%%
figure;
subplot(2,1,1);
x1 = fliplr(b.open_circuit_voltage_map_discharge_V.axis_1.breakpoints).*b.num_parallel_cells.*b.open_circuit_voltage_map_discharge_V.table.*b.cell.capacity_nominal_Ah;
y1 = b.open_circuit_voltage_map_discharge_V.table - b.cell.capacity_nominal_Ah.*b.transient_R_discharge_long_term_Ohms;
plothg(x1,y1 );
xyt('Energy [Wh]','Battery Terminal Voltage [1C] [V]');
% REVS_plot_dynamic_lookup(b.open_circuit_voltage_map_discharge_V, 'title', 'OC_discharge_V');

subplot(2,1,2)
x2 = fliplr(b.open_circuit_voltage_map_discharge_V.axis_1.breakpoints).*b.num_parallel_cells.*b.open_circuit_voltage_map_charge_V.table.*b.cell.capacity_nominal_Ah;
y2 = b.open_circuit_voltage_map_charge_V.table - b.cell.capacity_nominal_Ah.*b.transient_R_charge_long_term_Ohms;
plothg(x2, y1);
xyt('Energy [Wh]','Battery Terminal Voltage [1C] [V]');
% REVS_plot_dynamic_lookup(b.open_circuit_voltage_map_charge_V, 'title', 'OC_charge_V');


end

