function [] = REVS_plot_drive_cycle( drive_cycle )
% function [] = REVS_plot_drive_cycle( drive_cycle )
% does what it says it does

if nargin == 0
    drive_cycle = evalin('caller','drive_cycle');
end

figure;
subplot(2,1,1)
hold on;
legend on;
grid on;

if isfield(drive_cycle, 'cycle_speed_mps_raw')
    plot(drive_cycle.cycle_time_raw, drive_cycle.cycle_speed_mps_raw,'m.-', 'DisplayName', 'raw speed')
end

plot(drive_cycle.cycle_time,drive_cycle.cycle_speed_mps,'b.-', 'linewidth', 2, 'DisplayName', 'speed');
stairs(drive_cycle.ignition_time,drive_cycle.ignition*30,'r.-', 'linewidth', 2, 'DisplayName', 'ignition');
stairs(drive_cycle.in_gear_time,drive_cycle.in_gear*35,'g.-', 'linewidth', 2, 'DisplayName', 'in gear');
stairs(drive_cycle.phase_time, drive_cycle.phase,'k-', 'linewidth', 2, 'DisplayName', 'phase');
xlabel('Time (S)');

subplot(2,1,2);
hold on;
legend on;
grid on;

dist = cumtrapz(drive_cycle.cycle_time, drive_cycle.cycle_speed_mps);
plot(drive_cycle.grade_dist_m, drive_cycle.grade_pct,'r.-', 'DisplayName', 'grade');
plot(dist,drive_cycle.cycle_speed_mps,'b.-', 'DisplayName', 'speed');

phase_dist = interp1( drive_cycle.cycle_time, dist, drive_cycle.phase_time,'linear','extrap');
stairs(phase_dist, drive_cycle.phase,'k-', 'linewidth', 2, 'DisplayName', 'phase');
%plot(phase_dist, drive_cycle.phase,'kx');
xlabel('Distance (m)');

end

