function [] = REVS_plot_dynamic_lookup( dl, varargin )
%REVS_plot_dynamic_lookup
% code to try to automatically plot a dynamic lookup table...

axis_handle = parse_varargs(varargin,'axis', gca);
title_str   = parse_varargs(varargin,'title','table','string');
surface_mode = parse_varargs(varargin,'surface','contour','string');

if isempty(axis_handle)
    figure;
    axis_handle = gca;
end

if dl.num_dimensions == 1
    plothg(dl.axis_1.breakpoints, dl.table);
    %add_legend(dl.axis_1.signal);
    xyt(dl.axis_1.signal, title_str);
elseif dl.num_dimensions == 2
    if isequal(surface_mode, 'contour')
        contour(dl.axis_2.breakpoints, dl.axis_1.breakpoints, dl.table, 'ShowText', 'on');
        xyt(dl.axis_2.signal, dl.axis_1.signal, title_str);
    end    
else
end

end

