function REVS_plot_emachine(emachine, plot_types, varargin)

% quadrants                   = parse_varargs(varargin,'quadrants', 2);
%
% no_figure                   = parse_varargs(varargin,'no_figure',(false),'toggle');
% contour_levels              = parse_varargs(varargin,'contours',[],'numeric',{'vector'});
% contour_filled              = parse_varargs(varargin,'filled',false,'toggle');
% contour_labels              = parse_varargs(varargin,'no_contour_labels',true,'toggle');
% contour_width               = parse_varargs(varargin,'contour_width',1,'numeric');
% contour_color               = parse_varargs(varargin,'contour_color','auto');
% contour_cmap                = parse_varargs(varargin,'colormap','jet','colormap');
%
% title_str                   = parse_varargs(varargin,'title','','string');
%
% gb_test.speeds_rpm          = parse_varargs(varargin,'speeds',[]);
% gb_test.torques_Nm          = parse_varargs(varargin,'torques',[]);

validate_arg(plot_types, {'cellstr'}, {'efficiency','elec consumption', 'power', 'power loss', 'current', 'torque loss', 'torque loss data'});

quadrants                   = parse_varargs(varargin,'quadrants', 2);

no_figure                   = parse_varargs(varargin,'no_figure',(false),'toggle');
contours					= parse_varargs(varargin,'contours',[],'numeric',{'vector'});
contour_filled              = parse_varargs(varargin,'filled',false,'toggle');
contours_labels             = parse_varargs(varargin,'no_contour_labels',true,'toggle');
contour_width               = parse_varargs(varargin,'contour_width',1,'numeric');
contour_color               = parse_varargs(varargin,'contour_color','auto');
contour_cmap                = parse_varargs(varargin,'colormap','jet','colormap');

plot_power_lines            = parse_varargs(varargin,'no_power_lines',true,'toggle');

highlight_patch             = parse_varargs(varargin,'highlight_contour',[],'numeric');
highlight_color             = parse_varargs(varargin,'highlight_color',[0.50,.85,0.50],'numeric');
highlight_alpha             = parse_varargs(varargin,'highlight_alpha',[],'numeric',{'scalar'});

line_width					= parse_varargs(varargin,'line_width',2,'numeric');
fill_outside				= parse_varargs(varargin,'show_above_wot',true,'toggle');

title_str                   = parse_varargs(varargin,'title','','string');


voltage                     = parse_varargs(varargin,'voltage',[],'numeric');

out.speeds_rpm              = parse_varargs(varargin,'speeds',[]);
out.torques_Nm              = parse_varargs(varargin,'torques',[]);

show_point_labels           = parse_varargs(varargin,'show_point_labels',(false),'logical');
show_points                 = parse_varargs(varargin,'show_points',(false),'logical');

heatmap_data				= parse_varargs(varargin,'heatmap',[]);
heatmap_integrate			= parse_varargs(varargin,'heatmap_type','','char');
heatmap_time_range			= parse_varargs(varargin,'heatmap_time_range',[]);
heatmap_point_select		= parse_varargs(varargin,'heatmap_point_select',[]);
time_data                   = parse_varargs(varargin,'time',[]);

% %% setup gb_test limits
%
% %Speeds
% if isempty(out.speeds_rpm)
%     out.speeds_rpm = emachine.electric_power_W.get_signal_breakpoints( obj, 'emach_spd_radps') * unit_convert.radps2rpm;
% end
% out.max_speed_rpm = out.speeds_rpm(end);
%
%
% %Torques
% if isempty(out.torques_Nm)
%     out.torques_Nm = emachine.electric_power_W.get_signal_breakpoints( obj, 'emach_trq_Nm');
% end
% out.max_torque_Nm = out.torques_Nm(end);
%
% out.dims = [length(out.torques_Nm),length(out.speeds_rpm)];



%% Create Fine Mesh for making smooth images

lu_vararg = {};

if ~isempty(voltage)
    lu_vararg = {'emach_voltage_V',voltage};
end

% Pull information from emachine
[max_curve.speed_radps, max_curve.torque_Nm] = emachine.get_max_torque_curve( lu_vararg{:});
[min_curve.speed_radps, min_curve.torque_Nm] = emachine.get_min_torque_curve(lu_vararg{:});
[elec_map.speed_radps, elec_map.torque_Nm, elec_map.consumption_gps] = emachine.get_electric_power_map(lu_vararg{:});


% Make higher resolution versions for smooth plotting
switch quadrants
    case 1
        hires_speeds_radps = linspace(0, max(elec_map.speed_radps(:)), 250 );
%         hires_speeds_radps = linspace(min(elec_map.speed_radps(elec_map.speed_radps > 0)), max(elec_map.speed_radps(:)), 250 );
%         hires_speeds_radps = linspace(0, 16000*(pi/30), 250 );
        hires_torques_Nm = linspace(0,max(elec_map.torque_Nm(:)),220);
%         hires_torques_Nm = linspace(0,421.6,220);
    case 2
        hires_speeds_radps = linspace(0, max(elec_map.speed_radps(:)), 250 );
%         hires_speeds_radps = linspace(min(elec_map.speed_radps(elec_map.speed_radps > 0)), max(elec_map.speed_radps(:)), 250 );
%         hires_speeds_radps = linspace(0, 16000*(pi/30), 250 );
        hires_torques_Nm = linspace(min(elec_map.torque_Nm(:)),max(elec_map.torque_Nm(:)),220);
%         hires_torques_Nm = linspace(-421.6,421.6,220);
    case 4
        hires_speeds_radps = linspace(min(elec_map.speed_radps(:)), max(elec_map.speed_radps(:)), 250 );
        hires_torques_Nm = linspace(min(elec_map.torque_Nm(:)),max(elec_map.torque_Nm(:)),220);
    otherwise
        error('Undefined quadrants argument ''%i''.',quadrants);
end

[mesh_speed_radps, mesh_torque_Nm] = meshgrid( hires_speeds_radps, hires_torques_Nm);
mesh_speed_rpm = mesh_speed_radps .* unit_convert.radps2rpm;
mesh_mech_power_W = mesh_speed_radps.* mesh_torque_Nm;

mesh_elec_power_W = interp2( elec_map.speed_radps, elec_map.torque_Nm, elec_map.consumption_gps, mesh_speed_radps, mesh_torque_Nm);
% mesh_elec_power_W = interp2( elec_map.speed_radps, elec_map.torque_Nm, elec_map.consumption_gps, mesh_speed_radps, mesh_torque_Nm,'makima',nan);

% % Willans Approach 
% % Linear regression fit
% fit_elecpwr_pos = [1.12958691034701; -10769.4576166895];
% fit_elecpwr_neg = [0.865332441684965;-10731.2708006610];
% 
% for i = 1:length(mesh_elec_power_W(:,1))
%     for j = 1:length(mesh_elec_power_W(1,:))
%         if mesh_torque_Nm(i,j) >= 0
%             Pelec_est(i,j) = (mesh_speed_radps(i,j) .* mesh_torque_Nm(i,j)) * fit_elecpwr_pos(1) + fit_elecpwr_pos(2);
%         else
%             Pelec_est(i,j) = (mesh_speed_radps(i,j) .* mesh_torque_Nm(i,j)) * fit_elecpwr_neg(1) + fit_elecpwr_neg(2);
%         end
%     end
% end
% 
% mesh_elec_power_W = [Pelec_est(:,1:5) mesh_elec_power_W(:,6:end)];

% Willans Approach 
% Linear regression fit
% fit_elecpwr_pos = [1.28; -108.49];
% fit_elecpwr_neg = [1.1466;5.7651];
% 
% for i = 1:length(mesh_elec_power_W(:,1))
%     for j = 1:length(mesh_elec_power_W(1,:))
%         if mesh_torque_Nm(i,j) >= 0
%             Pelec_est(i,j) = (mesh_speed_radps(i,j) .* mesh_torque_Nm(i,j) * fit_elecpwr_pos(1)) + fit_elecpwr_pos(2);
%         else
%             Pelec_est(i,j) = (mesh_speed_radps(i,j) .* mesh_torque_Nm(i,j) * fit_elecpwr_neg(1)) + fit_elecpwr_neg(2);
%         end
%     end
% end

% mesh_elec_power_W = [Pelec_est(:,1:16) mesh_elec_power_W(:,17:end)];

% mesh_elec_power_W(:,1:16) = repmat(mesh_elec_power_W(:,17),1,16);

over_max =  mesh_torque_Nm >  interp1(max_curve.speed_radps, max_curve.torque_Nm, mesh_speed_radps) +  0.05*max(max_curve.torque_Nm);
under_min = mesh_torque_Nm <  interp1(min_curve.speed_radps, min_curve.torque_Nm, mesh_speed_radps) -  0.05*min(min_curve.torque_Nm);

mesh_mech_power_W( over_max | under_min ) = nan;
mesh_elec_power_W( over_max | under_min ) = nan;

if ~iscell(plot_types)
    plot_types = cellstr(plot_types);
end

for plot_type_idx = 1:numel( plot_types)
    
    plot_type = plot_types{plot_type_idx};
    
    switch upper(plot_type)
        case {'EFF','EFFICIENCY'}
            plot_data = 100*(1- abs( mesh_elec_power_W - mesh_mech_power_W ) ./ max(abs(mesh_elec_power_W), abs(mesh_mech_power_W)));
            contour_levels = set_if_empty(contours,[10 20 30 40 50 60 70 75 80 85 87.5 90:1:100]);
            title_plot_type_append = "Efficiency ( % )";
        case {'ELEC CONSUMPTION','POWER'}
            plot_data = mesh_elec_power_W / 1e3;
            max_contour = max(0,ceil(max(plot_data(:))));
            min_contour = min(0,floor(min(plot_data(:))));
            increment = round((max_contour - min_contour) /20);
            contour_levels = set_if_empty(contours,unique( [0:increment:max_contour, 0:-increment:min_contour]));
            title_plot_type_append = "Electrical Power ( kW )";
        case {'POWER LOSS'}
            plot_data = abs( mesh_elec_power_W - mesh_mech_power_W );
            max_contour = max(0,ceil(max(plot_data(:))));
            increment = 10*round(max_contour /200);
            contour_levels = set_if_empty(contours,0:increment:max_contour);
            %             contour_levels = set_if_empty(contours,[0:100:2000 2000:100:4500 4500:1000:25000]);
            title_plot_type_append = "Power Loss ( W )";
        case {'TORQUE LOSS'}
            plot_data = abs( mesh_elec_power_W - mesh_mech_power_W ) ./ mesh_speed_radps;
            max_contour = max(0,ceil(max(plot_data(:))));
            increment = 10*round(max_contour /200);
            contour_levels = set_if_empty(contours,[0:2:50 50:5:100 100:25:600]);
            %             contour_levels = set_if_empty(contours,0:increment:max_contour);
            title_plot_type_append = "Torque Loss ( Nm )";
        case {'TORQUE LOSS DATA'}
            data_speed_rpm = emachine.gen_raw_data_in.speed_rpm;
            data_mech_power_W = data_speed_rpm .* unit_convert.rpm2radps .* emachine.gen_raw_data_in.torque_Nm;
            data_elec_power_W = data_mech_power_W ./ emachine.gen_raw_data_in.efficiency_norm;
            torque_loss_Nm = abs( data_elec_power_W - data_mech_power_W ) ./ (data_speed_rpm .* unit_convert.rpm2radps);

            gspeeds = unique(data_speed_rpm);
            fig = figure('Position', [200, 200, 800, 600] ) ;
            ax = axes;
            colors = jet(length(gspeeds));
            for i = 1:length(gspeeds)
               idx = find(data_speed_rpm == gspeeds(i));
               semilogy(emachine.gen_raw_data_in.torque_Nm(idx), torque_loss_Nm(idx),'-*','linewidth',line_width,'color',colors(i,1:end)...
                   ,'DisplayName',strcat('Speed = ',num2str(round(gspeeds(i),0)))); hold on;
            end
            xlabel(ax,'Output Torque ( Nm )');
            ylabel(ax,'Effective Torque loss ( Nm )');
            title(["EMOT Effective Torque Loss vs Output Torque","(for drive quadrant)"])
            xlim([0 inf])
            grid on;
            legend('show')
              
            gtorque = unique(emachine.gen_raw_data_in.torque_Nm);
            fig = figure('Position', [200, 200, 800, 600] ) ;
            ax = axes;
            colors = jet(length(gtorque));
            for i = 1:length(gtorque)
               idx = find(emachine.gen_raw_data_in.torque_Nm == gtorque(i));
               semilogy(emachine.gen_raw_data_in.speed_rpm(idx), torque_loss_Nm(idx),'-*','linewidth',line_width,'color',colors(i,1:end)...
                   ,'DisplayName',strcat('Torque = ',num2str(round(gtorque(i),0)))); hold on;
            end
            xlabel(ax,'Speed ( RPM )');
            ylabel(ax,'Effective Torque loss ( Nm )');
            title(["EMOT Effective Torque Loss vs Speed","(for drive quadrant)"])     
            xlim([0 inf])
            grid on;
            legend('show')            
        break
    end

    if no_figure
        fig = gcf;
        ax = gca;
    else
        fig = figure('Position', [200, 200, 800, 600] ) ;
        ax = axes;
    end
    
    if ~isempty(highlight_patch)
        c = contourc(hires_speeds_radps .* unit_convert.radps2rpm, hires_torques_Nm, plot_data , contour_levels);
        idx = 1;
        contour_size = size(c,2);
        while idx < contour_size
            if c(1,idx) == highlight_patch
                num_pts = c(2,idx);
                x_pts = c(1,idx+(1:num_pts));
                y_pts = c(2,idx+(1:num_pts));
                
                h = patch(x_pts,y_pts,highlight_color);
                if ~isempty( highlight_alpha )
                    alpha(h,highlight_alpha);
                end
                
            end
            idx = idx + c(2,idx) +1;
        end
        hold on
    end
    
    
    % Additional Contour Plotting Arguments
    addtl_args = { 'linewidth',contour_width, 'color', contour_color};
    
    if contour_filled
        [c,h] = contourf(ax, mesh_speed_rpm, mesh_torque_Nm, plot_data , contour_levels ,addtl_args{:});
    else
        [c,h] = contour(ax, mesh_speed_rpm, mesh_torque_Nm, plot_data , contour_levels ,addtl_args{:});
    end
    
    %assignin('base','h',h)
    cmap = contour_cmap;
    if ischar( cmap)
        cmap = eval(cmap);
    end
    
    
    % Linearize colormap based on contour levels
    contour_levels_norm = unique((contour_levels - min(contour_levels)) ./ ( max(contour_levels) - min(contour_levels)));
    cmap_convert = interp1( contour_levels_norm, linspace(0,1,length(contour_levels_norm)), linspace(0,1,size(cmap,1)));
    cmap = interp1( linspace(0,1,size(cmap,1)),cmap, cmap_convert);
    colormap(cmap);
    
    if contours_labels
        clabel(c,h,'labelspacing',144,'color',[0.5,0.5,0.5],'fontweight','bold')
    end
    
    hold on
    
    % Draw line @ 0 - just because
    plot([0, 20000],[0,0],'-','color',[0.5, 0.5, 0.5], 'linewidth', line_width);
    
    
    % Draw Data points
    
    if ~isempty(emachine.gen_raw_data_in) && show_points
        
        data_colors = {'k','lg','m','db','dg','c'};
        line_handles = [];
        
        
        if isfield(emachine.gen_raw_data_in,'efficiency_norm')
            if any(size(emachine.gen_raw_data_in.efficiency_norm) == 1) && ~isempty(voltage)
                pts.speeds = emachine.gen_raw_data_in.speed_rpm(emachine.gen_raw_data_in.voltage_V == voltage);
                pts.torque = emachine.gen_raw_data_in.torque_Nm(emachine.gen_raw_data_in.voltage_V == voltage);
                pts.eff_norm = emachine.gen_raw_data_in.efficiency_norm(emachine.gen_raw_data_in.voltage_V == voltage);
                
            elseif any(size(emachine.gen_raw_data_in.efficiency_norm) == 1) && isempty(voltage)
                pts.speeds = emachine.gen_raw_data_in.speed_rpm;
                pts.torque = emachine.gen_raw_data_in.torque_Nm;
                pts.eff_norm = emachine.gen_raw_data_in.efficiency_norm;
                
            elseif ~isempty(voltage)
                pts.idx = cellfun(@(v)any(v(:)== voltage),{emachine.gen_raw_data_in.voltage_V});
                [pts.speeds,pts.torque] = meshgrid(emachine.gen_raw_data_in(pts.idx).speed_rpm,emachine.gen_raw_data_in(pts.idx).torque_Nm);
                pts.eff_norm = emachine.gen_raw_data_in(pts.idx).efficiency_norm;
            else
                pts.idx = 1;
                [pts.speeds,pts.torque] = meshgrid(emachine.gen_raw_data_in(pts.idx).speed_rpm,emachine.gen_raw_data_in(pts.idx).torque_Nm);
                pts.eff_norm = emachine.gen_raw_data_in(pts.idx).efficiency_norm;
                
            end
        end
       
        superplot(pts.speeds(:),  pts.torque(:) , 'k.');
        if show_point_labels
          h = text( pts.speeds(:) , pts.torque(:) , num2str(pts.eff_norm(:),'%02.2f' ),'FontSize',8,'VerticalAlignment','bottom');
    			set(h,'Clipping','on');
        end
    end 
    
    % Plot heat map overlay
    if ~isempty(heatmap_data)
        REVS_plot_emachine_heatmap_overlay( heatmap_data, 'heatmap_type', heatmap_integrate, 'heatmap_time_range', heatmap_time_range, 'heatmap_point_select', heatmap_point_select ,'time',time_data);
    end
    
    
    % Draw CTP Torque
    plot(ax, min_curve.speed_radps * unit_convert.radps2rpm, min_curve.torque_Nm,'k-','linewidth',line_width)
    
    % Draw WOT Torque
    plot(ax, max_curve.speed_radps * unit_convert.radps2rpm, max_curve.torque_Nm,'k-','linewidth',line_width)
    
    if plot_power_lines
        powerlines( 'z_offset',1);
    end
    
    % Set Extents
    xlim( 1.05*[hires_speeds_radps(1), hires_speeds_radps(end)] * unit_convert.radps2rpm);
    ylim( 1.05*[hires_torques_Nm(1), hires_torques_Nm(end)]);
    
    % Apply Labels
    xlabel(ax,'Speed ( RPM )');
    ylabel(ax,'Torque ( Nm )');
    
    if (~isprop(emachine,'name') && ~isfield( emachine, 'name' )) || isempty(emachine.name)
        emachine.name = 'Electric Motor';
    end
    
    if ~isempty(title_str)
        title([title_str,title_plot_type_append]);
    else
        title(sprintf('%s\n%s',strrep(emachine.name,'_',' '), title_plot_type_append));
    end
    
    if fill_outside
        f1 = fill([ 20000; 20000; 0; 0; max_curve.speed_radps(:) * unit_convert.radps2rpm; max_curve.speed_radps(end) * unit_convert.radps2rpm; ],[0; 20000; 20000; 0; max_curve.torque_Nm(:); 0],[0.8 0.8 1.0]);
        f1.ZData = 0.5*ones(size(f1.XData));
        f2 = fill([ 20000; 20000; min_curve.speed_radps(1) * unit_convert.radps2rpm; 0; min_curve.speed_radps(:) * unit_convert.radps2rpm; max_curve.speed_radps(end) * unit_convert.radps2rpm; ],[0; -20000; -20000; 0; min_curve.torque_Nm(:); 0],[0.8 0.8 1.0]);
        f2.ZData = 0.5*ones(size(f2.XData));
    end
    
    
end

end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   SUB FUNCTIONS   %%%%%%%%%%%%%%%%%%%%%%%%%%

function out = set_if_empty( in, empty_val)

if isempty(in)
    out = empty_val;
else
    out = in;
end

end

