function [ch] = REVS_plot_emachine_heatmap_overlay( heatmap_data, varargin )
% First version of heatmap for emachines based on engine. Still need to
% streamline the code to account for different naming of emachines and
% remove dependency of separate time array
heatmap_integrate			= parse_varargs(varargin,'heatmap_type','','char');
heatmap_time_range			= parse_varargs(varargin,'heatmap_time_range',[]);
heatmap_point_select		= parse_varargs(varargin,'heatmap_point_select',[]);
time_data                   = parse_varargs(varargin,'time',[]);

	
		if 0 %isa(heatmap_data,'class_test_data')
			
% 			% select variables from class_test_data
% 			
% 			heatmap_speed = heatmap_data.engine.speed_rpm;
% 			heatmap_time = heatmap_data.time;
% 			heatmap_torque = heatmap_data.emachine.torque_Nm;
% 			
% 			if isempty( heatmap_integrate )
% 				heatmap_value = heatmap_torque .* heatmap_speed / 9549.3;
% 			else
% 				heatmap_value = eval(['heatmap_data.emachine.', heatmap_integrate]);
% 			end
			
		elseif isa(heatmap_data,'class_emachine_data')
			
			% select variables from class_test_data
			
			heatmap_speed = heatmap_data.speed_rpm;
			heatmap_time = time_data;
			heatmap_torque = heatmap_data.torque_Nm;
			
% 			if isempty( heatmap_integrate )
				heatmap_value = abs(heatmap_torque .* heatmap_speed / 9549.3);
% 			else
% 				heatmap_value = eval(['heatmap_data.engine.', heatmap_integrate]);
% 			end	
			
		elseif isa(heatmap_data,'class_REVS_logging_object') 
			
			% select variables form audit structure
			heatmap_torque = heatmap_data.output_trq_Nm;
			
			if isprop( heatmap_data, 'output_spd_radps' )
				heatmap_speed = heatmap_data.output_spd_radps * unit_convert.radps2rpm;
			end
				
			heatmap_time = time_data;
			
			if isempty( heatmap_integrate )
				heatmap_value = abs(heatmap_torque .* heatmap_speed / 9549.3);
			else
				heatmap_value = eval(['heatmap_data.engine.', heatmap_integrate]);
			end
			
		else
			error('Unknown heatmap data format. Must be a class_test_data or class_REVS_datalog containing necessary signals');
			
		end
		
		% Remove energy from excluded region
		if ~isempty( heatmap_time_range)
			heatmap_value( heatmap_time < heatmap_time_range(1) ) = 0;
			heatmap_value( heatmap_time > heatmap_time_range(end) ) = 0;
		end
		
		if ~isempty(heatmap_point_select)
			heatmap_value( ~heatmap_point_select ) = 0;
		end
		
		
		% Reduce weighting of idle
% 		heatmap_value = max(0,heatmap_value .* (0.5+0.5*(heatmap_speed > 1000)));
		heatmap_value = max( 0,heatmap_value );

		
		caxis_min = interp1([2,length(jet)+1], caxis, 1,'linear','extrap');
		caxis_max = max(caxis);
		min_torque = min( ylim );
		max_torque = max( ylim );

		[~,ch] = newhist2d(heatmap_speed, linspace(-20000,20000,100), heatmap_torque, linspace(min_torque,max_torque,25), heatmap_value, heatmap_time,caxis_min, caxis_max);

		shading interp;

		ch.ZData = ch.ZData-2;
		alpha(ch, 0.65);
		colormap([1,1,1; jet])
		
		caxis([caxis_min, caxis_max]);
		
end