function REVS_plot_engine(e, plot_types, varargin)
% % REVS_plot_engine(e, format, varargin)
% no_figure                   = parse_varargs(varargin,'no_figure',(false),'toggle');
% contour_levels              = parse_varargs(varargin,'contours',[],'numeric',{'vector'});
% contour_filled              = parse_varargs(varargin,'filled',false,'toggle');
% contours_labels             = parse_varargs(varargin,'no_contour_labels',true,'toggle');
% contour_width               = parse_varargs(varargin,'contour_width',1,'numeric');
% contour_color               = parse_varargs(varargin,'contour_color','auto');
% contour_cmap                = parse_varargs(varargin,'colormap','jet','colormap');
%
% plot_power_lines            = parse_varargs(varargin,'no_power_lines',true,'toggle');
% plot_min_bsfc               = parse_varargs(varargin,'no_min_bsfc',true,'toggle');
% plot_na_curve               = parse_varargs(varargin,'no_na_curve',true,'toggle');
% plot_ctp_curve				= parse_varargs(varargin,'show_ctp_curve',false,'toggle');
% plot_deac_norm				= parse_varargs(varargin,'deac_prop',1.0,'numeric',{'scalar'});
%
% highlight_patch             = parse_varargs(varargin,'highlight_contour',[],'numeric');
% highlight_color             = parse_varargs(varargin,'highlight_color',[0.50,.85,0.50],'numeric');
% highlight_alpha             = parse_varargs(varargin,'highlight_alpha',[],'numeric',{'scalar'});
%
% line_width					= parse_varargs(varargin,'line_width',3,'numeric');
% fill_outside				= parse_varargs(varargin,'show_above_wot',true,'toggle');
%
% time_range					= parse_varargs(varargin,'time_range',[]);
%
% heatmap_data				= parse_varargs(varargin,'heatmap',[]);
% heatmap_integrate			= parse_varargs(varargin,'heatmap_type','','char');
% heatmap_time_range			= parse_varargs(varargin,'heatmap_time_range',time_range);
%
% data_points_data			= parse_varargs(varargin,'data_points',[]);
% data_points_decimation		= parse_varargs(varargin,'data_points_decimation',1);
% data_points_time_range		= parse_varargs(varargin,'data_points_time_range',time_range);
%
% show_bmep					= parse_varargs(varargin,'show_bmep',false,'toggle');
% show_matrix_min_speeds      = parse_varargs(varargin,'show_matrix_min_speeds',false,'toggle');
% idle_plot					= parse_varargs(varargin,'idle_plot',false,'toggle');
% title_str                   = parse_varargs(varargin,'title','','string');

validate_arg(e, {'class_REVS_engine_base'});
% validate_arg(e, {'class_REVS_engine','class_REVS_detailed_engine'});
validate_arg(plot_types, {'cellstr'}, {'efficiency','fuel flow', 'fuel consumption','fuel per injection','BSFC','brake specific fuel','BS CO2', 'brake specific CO2','CO2'});

no_figure                   = parse_varargs(varargin,'no_figure',(false),'toggle');
contours					= parse_varargs(varargin,'contours',[],'numeric',{'vector'});
contour_filled              = parse_varargs(varargin,'filled',false,'toggle');
contours_labels             = parse_varargs(varargin,'no_contour_labels',true,'toggle');
contour_width               = parse_varargs(varargin,'contour_width',1,'numeric');
contour_color               = parse_varargs(varargin,'contour_color','auto');
contour_cmap                = parse_varargs(varargin,'colormap','jet','colormap');

plot_power_lines            = parse_varargs(varargin,'no_power_lines',true,'toggle');
plot_min_bsfc               = parse_varargs(varargin,'no_min_bsfc',true,'toggle');
plot_min_bsfc_bounds        = parse_varargs(varargin,'show_min_bsfc_bounds',false,'toggle');
plot_na_curve               = parse_varargs(varargin,'no_na_curve',true,'toggle');
plot_ctp_curve				= parse_varargs(varargin,'show_ctp_curve',false,'toggle');
plot_deac_norm				= parse_varargs(varargin,'deac_prop',[],{'numeric','char'});
% plot_redline				= parse_varargs(varargin,'show_redline',false,'toggle');

highlight_patch             = parse_varargs(varargin,'highlight_contour',[],'numeric');
highlight_color             = parse_varargs(varargin,'highlight_color',[0.50,.85,0.50],'numeric');
highlight_alpha             = parse_varargs(varargin,'highlight_alpha',[],'numeric',{'scalar'});

line_width					= parse_varargs(varargin,'line_width',2,'numeric');
fill_outside				= parse_varargs(varargin,'show_above_wot',true,'toggle');

time_range					= parse_varargs(varargin,'time_range',[]);

heatmap_data				= parse_varargs(varargin,'heatmap',[]);
heatmap_integrate			= parse_varargs(varargin,'heatmap_type','','char');
heatmap_time_range			= parse_varargs(varargin,'heatmap_time_range',time_range);
heatmap_point_select		= parse_varargs(varargin,'heatmap_point_select',[]);

data_points_data			= parse_varargs(varargin,'data_points',[]);
data_points_decimation		= parse_varargs(varargin,'data_points_decimation',1);
data_points_time_range		= parse_varargs(varargin,'data_points_time_range',time_range);

show_imep					= parse_varargs(varargin,'show_imep',false,'toggle');
show_bmep					= parse_varargs(varargin,'show_bmep',false,'toggle');
show_matrix_min_speeds      = parse_varargs(varargin,'show_matrix_min_speeds',false,'toggle');
idle_plot					= parse_varargs(varargin,'idle_plot',false,'toggle');
title_str                   = parse_varargs(varargin,'title','','string');


%% Create Fine Mesh for making smooth images

lu_vararg = {};

if ~isempty( plot_deac_norm )
    lu_vararg{end+1} = 'deac_prop'; 
    lu_vararg{end+1} = plot_deac_norm;
end

% Pull information from engine
[max_curve.speed_radps, max_curve.torque_Nm] = e.get_max_torque_curve( lu_vararg{:});

[min_curve.speed_radps, min_curve.torque_Nm] = e.get_min_torque_curve(lu_vararg{:});

[fuel_map.speed_radps, fuel_map.torque_Nm, fuel_map.consumption_gps] = e.get_fuel_map(lu_vararg{:});


% Make higher resolution versions of fuel map for smooth plotting 
hires_speeds_radps = linspace(min(max(fuel_map.speed_radps, 10)), max(fuel_map.speed_radps(:)), 250 );
hires_torques_Nm = linspace(min(fuel_map.torque_Nm(:)),max(fuel_map.torque_Nm(:)),220);

[mesh_speed_radps, mesh_torque_Nm] = meshgrid( hires_speeds_radps, hires_torques_Nm);
mesh_speed_rpm = mesh_speed_radps .* unit_convert.radps2rpm;

mesh_fuel_gps = interp2( fuel_map.speed_radps * unit_convert.radps2rpm, fuel_map.torque_Nm, fuel_map.consumption_gps, mesh_speed_rpm, mesh_torque_Nm);

for s = 1:length(hires_speeds_radps)		
	wot_torque = interp1(max_curve.speed_radps, max_curve.torque_Nm, hires_speeds_radps(s)) + 0.05*max(max_curve.torque_Nm);
	over_wot = hires_torques_Nm > wot_torque;		
	mesh_fuel_gps(over_wot,s) = NaN;		
end

if ~iscell(plot_types)
	plot_types = cellstr(plot_types);
end

for plot_type_idx = 1:numel( plot_types)
	
	plot_type = plot_types{plot_type_idx};
	
	switch upper(plot_type)
		case {'EFF','EFFICIENCY'}
			plot_data = 100 * ((mesh_speed_rpm .* mesh_torque_Nm) ./ 9549 ) ./ ( mesh_fuel_gps .* e.fuel.energy_density_MJpkg );
			plot_data(mesh_torque_Nm < 0) = nan;
            [max_Eff_spd_idx,max_Eff_trq_idx] = find(plot_data == max(max(plot_data)));
			contour_levels = set_if_empty(contours,[5,10, 15, 20, 23, 26:2:30, 32:50]);
			title_plot_type_append = 'Brake Thermal Efficiency ( % )';
		case {'FUEL FLOW', 'FUEL CONSUMPTION'}
			plot_data =  mesh_fuel_gps;
			max_contour = ceil(max(plot_data(:)));
			increment = max(0.5,round(max_contour/20));
			contour_levels = set_if_empty(contours,0:increment:max_contour);
			title_plot_type_append = 'Fuel Flow ( g/s )';
		case {'FUEL PER INJECTION'}
			plot_data =  mesh_fuel_gps *60 ./ mesh_speed_rpm / e.num_cylinders * 2*1000;
			max_contour = ceil(max(plot_data(~isinf(plot_data))));
			increment = max(0.5,round(max_contour/20));
			contour_levels = set_if_empty(contours,0:increment:max_contour);
			title_plot_type_append = 'Fuel Flow ( mg / inj )';
		case {'BSFC','BRAKE SPECIFIC FUEL'}
			plot_data = (mesh_fuel_gps .* 3600 .* 9549) ./ max(eps,mesh_speed_rpm .* mesh_torque_Nm);
			plot_data(mesh_torque_Nm < 0) = nan;
            [min_BSFC_spd_idx,min_BSFC_trq_idx] = find(plot_data == min(min(plot_data)));
			title_plot_type_append = 'Brake Specific Fuel Consumption ( g/kW*hr )';
			contour_levels = set_if_empty(contours,[190:10:250,190, 275:25:375, 400,450,500,600,750,1000]);
            if length(contour_levels) <= 19
                contour_levels = [190:10:250, 205, 195, 190, 275:25:375, 400,450,500,600,750,1000];
            end
		case {'CO2'}
			plot_data =  mesh_fuel_gps .* e.fuel.carbon_weight_fraction * (44.0095/12.0107);
			max_contour = ceil(max(plot_data(:)));
			increment = max(1,round(max_contour/20));
			contour_levels = set_if_empty(contours,0:increment:max_contour);
			title_plot_type_append = 'CO_2 Emissions ( g/s )';
		case {'BS CO2', 'BRAKE SPECIFIC CO2'}
			plot_data = (mesh_fuel_gps .* e.fuel.carbon_weight_fraction * (44.0095/12.0107) *  3600 .* 9549) ./ max(eps,mesh_speed_rpm .* mesh_torque_Nm);
			plot_data(mesh_torque_Nm < 0) = nan;
			title_plot_type_append = 'Brake Specific CO_2 ( g/kW*hr )';
			contour_levels = set_if_empty(contours,[600:25:750, 800:50:900, 1000, 1250, 1500, 2000, 3000,5000]);
		otherwise
			error('Unknown plot format %s',plot_type)
	end
		
	if no_figure
		fig = gcf;
		ax = gca;
	else
		
		fig = figure('Position', [200, 200, 800, 600] ) ;	
		ax = axes;
	end
	
	if ~isempty(highlight_patch)
		c = contourc(hires_speeds_radps .* unit_convert.radps2rpm, hires_torques_Nm, plot_data , contour_levels);
		idx = 1;
		contour_size = size(c,2);
		while idx < contour_size
			if c(1,idx) == highlight_patch
				num_pts = c(2,idx);
				x_pts = c(1,idx+(1:num_pts));
				y_pts = c(2,idx+(1:num_pts));
				
				h = patch(x_pts,y_pts,highlight_color);
				if ~isempty( highlight_alpha )
					alpha(h,highlight_alpha);
				end
				
			end
			idx = idx + c(2,idx) +1;
		end
		hold on
	end
	
	
	% Additional Contour Plotting Arguments
	addtl_args = { 'linewidth',contour_width, 'color', contour_color};
	
    if contour_filled
        [c,h] = contourf(ax, mesh_speed_rpm, mesh_torque_Nm, plot_data , contour_levels ,addtl_args{:});
    else
        [c,h] = contour(ax, mesh_speed_rpm, mesh_torque_Nm, plot_data , contour_levels ,addtl_args{:});
    end

      
	%assignin('base','h',h)
	cmap = contour_cmap;
	if ischar( cmap)
		cmap = eval(cmap);
	end
	
	
	% Linearize colormap based on contour levels
	contour_levels_norm = unique((contour_levels - min(contour_levels)) ./ ( max(contour_levels) - min(contour_levels)));
	cmap_convert = interp1( contour_levels_norm, linspace(0,1,length(contour_levels_norm)), linspace(0,1,size(cmap,1)));
	cmap = interp1( linspace(0,1,size(cmap,1)),cmap, cmap_convert);
	colormap(cmap);
	
	if contours_labels
		clabel(c,h,'labelspacing',144,'color',[0.5,0.5,0.5],'fontweight','bold')
	end
	
	hold on
    
    
    % Show the max BTE and min BSFC points in the corres/. plots 
    switch upper(plot_type)
        case {'EFF','EFFICIENCY'}
            plot(ax, mesh_speed_rpm(max_Eff_spd_idx,max_Eff_trq_idx),mesh_torque_Nm(max_Eff_spd_idx,max_Eff_trq_idx),'pentagram','MarkerFaceColor','green','MarkerEdgeColor','blue','MarkerSize',15);
            text(mesh_speed_rpm(max_Eff_spd_idx,max_Eff_trq_idx), mesh_torque_Nm(max_Eff_spd_idx,max_Eff_trq_idx),...
                num2str(plot_data(max_Eff_spd_idx,max_Eff_trq_idx),'%02.1f' ),'FontSize',8,'VerticalAlignment','bottom','Color','blue');
        case {'BSFC','BRAKE SPECIFIC FUEL'}
            plot(ax, mesh_speed_rpm(min_BSFC_spd_idx,min_BSFC_trq_idx), mesh_torque_Nm(min_BSFC_spd_idx,min_BSFC_trq_idx),'pentagram','MarkerFaceColor','green','MarkerEdgeColor','blue','MarkerSize',15);
            text(mesh_speed_rpm(min_BSFC_spd_idx,min_BSFC_trq_idx), mesh_torque_Nm(min_BSFC_spd_idx,min_BSFC_trq_idx),...
                num2str(plot_data(min_BSFC_spd_idx,min_BSFC_trq_idx),'%02.1f' ),'FontSize',8,'VerticalAlignment','bottom','Color','blue');
        otherwise            
    end
    
     
    % Draw Max NA Torque
    if plot_na_curve && ( isprop(e,'naturally_aspirated_torque_Nm') || isfield(e,'naturally_aspirated_torque_Nm') )
        plot(ax, e.naturally_aspirated_speed_radps * unit_convert.radps2rpm, e.naturally_aspirated_torque_Nm,'-.','linewidth',line_width,'color',[0.5,0.5,0.5])
    end
	
    
    if plot_min_bsfc || plot_min_bsfc_bounds
       min_bsfc_curves = e.min_bsfc_curves(); 
    end
    
    
	% Draw Minimum BSFC Line
	if plot_min_bsfc
		plot(ax,min_bsfc_curves.speed_radps * unit_convert.radps2rpm, min_bsfc_curves.torque_Nm, '-','color',[1.0, 0.5, 0.8], 'linewidth', line_width);
    end
	
	
    % Draw Minimum BSFC Bounds
	if plot_min_bsfc_bounds
		plot(ax,min_bsfc_curves.min_consumption_upper_speed_radps * unit_convert.radps2rpm, min_bsfc_curves.min_consumption_upper_torque_Nm, '--','color',[1.0, 0.5, 0.8], 'linewidth', line_width);
        plot(ax,min_bsfc_curves.min_consumption_lower_speed_radps * unit_convert.radps2rpm, min_bsfc_curves.min_consumption_lower_torque_Nm, '--','color',[1.0, 0.5, 0.8], 'linewidth', line_width);
	end
    
	% Draw line @ 0 - just because
	plot([0, 10000],[0,0],'-','color',[0.5, 0.5, 0.5], 'linewidth', line_width);
	
	% Draw CTP Torque
	plot(ax, min_curve.speed_radps * unit_convert.radps2rpm, min_curve.torque_Nm,'k-','linewidth',line_width)
	
	% Draw WOT Torque
	plot(ax, max_curve.speed_radps * unit_convert.radps2rpm, max_curve.torque_Nm,'k-','linewidth',line_width)
	

	% Set Extents
    idle_speed_radps = e.get_idle_speed_radps(lu_vararg{:});
    
    if isempty( idle_speed_radps )
%        x_min = min(e.fuel_map_speed_radps(e.fuel_map.speed_radps > 0)) * unit_convert.radps2rpm;
       x_min = 0.9 * idle_speed_radps * unit_convert.radps2rpm;
    else
       x_min = 0.9 * idle_speed_radps * unit_convert.radps2rpm;
    end
	
	x_max = REVS_calc_engine_power_speed(e, 0.95, 'max') * unit_convert.radps2rpm;
	
    y_min = plot_ctp_curve * 1.1 * min(min_curve.torque_Nm);
	y_max = 1.05 *max(max_curve.torque_Nm);
	
	
	xlim( [x_min,x_max]);
	ylim( [y_min,y_max]);
	
	if plot_power_lines
		powerlines( 'z_offset',1);
	end
	
	if show_bmep
		ax2 = axes('position',[0.08,0.11, 0.001, 0.815]);
		set(ax2,'YColor','b');
		set(ax2,'Color',get(fig,'color'));
		ylabel('{\color{black}Torque ( Nm )}       {\color{blue}BMEP ( Bar )}','Interpreter', 'tex');
		ylim(ax2, [y_min;y_max] *  4 * pi / (e.displacement_L *100) );
		set(ax2,'XTickLabel','');
		
 		addlistener(ax,'YLim','PostSet', @(src,evt)bmep_axis_callback(src,evt, ax,ax2, 4 * pi / (e.displacement_L *100) ) );
% 		addlistener(ax,{'Position','OuterPosition','YLim'},'PostSet', @(src,evt)bmep_axis_callback(src,evt, ax,ax2, 4 * pi / (e.displacement_L *100) ) );
 		addlistener(ax,'LocationChanged', @(src,evt)bmep_axis_callback(src,evt, ax,ax2, 4 * pi / (e.displacement_L *100) ) );
 		addlistener(ax,'SizeChanged', @(src,evt)bmep_axis_callback(src,evt, ax,ax2, 4 * pi / (e.displacement_L *100) ) );

		set(ax2,'HandleVisibility','off');
        
    elseif show_imep
        ax2 = axes('position',[0.08,0.11, 0.001, 0.815]);
		set(ax2,'YColor','b');
		set(ax2,'Color',get(fig,'color'));
		ylabel('{\color{black}Indicated Torque ( Nm )}       {\color{blue}IMEP ( Bar )}','Interpreter', 'tex');
        
        % Calculate friction torque
        CT_speed_radps = unit_convert.rpm2radps*[0 657.2 812.1 1050 1991 3008 4064 4555 7000];
        CT_torque_Nm = [-26.32, -30.57 -32.01 -34.12 -39.84 -45.98 -52.72 -55.77,-71.58] * e.displacement_L / 3.3;
        T_frc = interp1(CT_speed_radps,CT_torque_Nm,min_curve.speed_radps,'linear');
        
%         T_frc = interp1(e.closed_throttle_speed_radps, e.closed_throttle_torque_Nm, min_curve.speed_radps,'linear');
		ylim(ax2, [y_min + abs(T_frc(1));(y_max + abs(T_frc(2)))] *  4 * pi / (e.displacement_L *100) );
		set(ax2,'XTickLabel','');
		
 		addlistener(ax,'YLim','PostSet', @(src,evt)bmep_axis_callback(src,evt, ax,ax2, 4 * pi / (e.displacement_L *100) ) );
% 		addlistener(ax,{'Position','OuterPosition','YLim'},'PostSet', @(src,evt)bmep_axis_callback(src,evt, ax,ax2, 4 * pi / (e.displacement_L *100) ) );
 		addlistener(ax,'LocationChanged', @(src,evt)bmep_axis_callback(src,evt, ax,ax2, 4 * pi / (e.displacement_L *100) ) );
 		addlistener(ax,'SizeChanged', @(src,evt)bmep_axis_callback(src,evt, ax,ax2, 4 * pi / (e.displacement_L *100) ) );

		set(ax2,'HandleVisibility','off');
		
	else
		ylabel(ax,'Torque ( Nm )');
	end
	
	
	% Plot heat map overlay
	if ~isempty(heatmap_data)
		REVS_plot_engine_heatmap_overlay( heatmap_data, 'heatmap_type', heatmap_integrate, 'heatmap_time_range', heatmap_time_range, 'heatmap_point_select', heatmap_point_select );
	end
	
	% Plot operational data point cloud
	if ~isempty( data_points_data)
				
		if isa(data_points_data,'class_test_data')			
			% select variables from class_test_data
			data_points_torque = data_points_data.engine.crankshaft_torque_Nm;
			data_points_speed = data_points_data.engine.speed_rpm;
			data_points_time = data_points_data.time;
			
 			if ~isempty( data_points_label )
				data_points_value = data_points_data.engine.crankshaft_power_kW;
 			end						
		elseif isstruct(data_points_data) && isfield(data_points_data,'mech') && isfield( data_points_data.mech, 'engine')			
			% select variables form audit structure
			data_points_torque = data_points_data.mech.engine.crankshaft_torque_Nm;
			data_points_speed = data_points_data.mech.engine.speed_rpm;
			data_points_time = data_points_data.time;
			
			if ~isempty( data_points_label )
				data_points_value = data_points_data.mech.engine.crankshaft_power_kW;
			end		
		end
		
		pts_idx = 1:data_points_decimation:length( data_points_speed);
		if ~isempty( data_points_time_range )
			pts_idx( data_points_time(pts_idx) < data_points_time_range(1)) = [];
			pts_idx( data_points_time(pts_idx) > data_points_time_range(end)) = [];
		end
		
		plothg( data_points_speed(pts_idx), data_points_torque(pts_idx), 'r.','MarkerSize',1 )
		if ~isempty( data_points_value )
			%TODO: Add value labels
		end
			
	end
	
	% Apply Labels
	xlabel(ax,'Speed ( RPM )');
	
	if (~isprop(e,'name') && ~isfield( e, 'name' )) || isempty(e.name)
		e.name = 'Engine';
    end
	
    
    % Apply clinderdeac proportionately
    if isempty( plot_deac_norm)
        title_deac_append = '';
    elseif  ischar(plot_deac_norm) && strcmpi( plot_deac_norm,'deac')
        title_deac_append  = '- Cylinder Deac Only';
    elseif  ischar(plot_deac_norm) && strcmpi( plot_deac_norm,'enabled')
        title_deac_append  = '- Cylinder Deac Enabled';
    elseif  ischar(plot_deac_norm) && strcmpi( plot_deac_norm,'disabled')
        title_deac_append  = '- Cylinder Deac Disabled';
    elseif  ischar(plot_deac_norm) 
        error('Unknown deac_prop string value "%s"', plot_deac_norm );
    else
        title_deac_append  = sprintf('- %2d%% Cylinder Deac', plot_deac_norm*100);
    end

    
	if ~isempty(title_str)
		title(title_str);
	else
		title(sprintf('%s %s\n%s',strrep(e.name,'_',' '), title_deac_append, title_plot_type_append));
	end
	
	if fill_outside
		f1 = fill([ 10000; 10000; 0; 0; max_curve.speed_radps(:) * unit_convert.radps2rpm; max_curve.speed_radps(end) * unit_convert.radps2rpm; ],[0; 10000; 10000; 0; max_curve.torque_Nm(:); 0],[0.8 0.8 1.0]);
		f1.ZData = 0.5*ones(size(f1.XData));
		f2 = fill([ 10000; 0; 0; min_curve.speed_radps(:) * unit_convert.radps2rpm; 10000 ],[ -10000; -10000; min_curve.torque_Nm(1); min_curve.torque_Nm(:); min_curve.torque_Nm(end)],[0.8 0.8 1.0]);
		f2.ZData = 0.5*ones(size(f2.XData));
	end

end

if idle_plot
	idle_fuel_gps = interp2( e.fuel_map_speed_radps, e.fuel_map_torque_Nm, e.fuel_map_consumption_gps , e.idle_speed_radps.table(1) * ones(size(hires_torques_Nm)), hires_torques_Nm);
	
	fplothg(hires_torques_Nm, idle_fuel_gps);
	
	xyt([e.name ' Torque at Idle, ' num2str(e.idle_speed_radps.table(1) * unit_convert.radps2rpm) ' RPM'],'Fuel Rate (g/s)');
	text(-40,1.9,['Disp [L]: ' num2str(e.displacement_L)]);
	text(-40,1.8125,['Inertia [kg-m^2]: ' num2str(e.inertia_kgm2)]);
	text(-40,1.7,['Speed [RPM]: ' num2str(e.idle_speed_radps.table(1) * unit_convert.radps2rpm)]);
	text(-40,1.6,['Motoring Torque [Nm]: ' num2str(interp1(e.min_curve_speed_radps, e.min_curve_torque_Nm,e.idle_speed_radps.table(1),'linear','extrap'))]);
	
	%    legend off;
	ylim([0 2]);
	xlim([-50 250]);
	
	eff = (hires_torques_Nm * e.idle_speed_radps.table(1) / 10)./(idle_fuel_gps * e.fuel.energy_density_MJpkg);
	plothg(hires_torques_Nm, eff/25,'g.-');
	plot(hires_torques_Nm(eff == max(eff)), max(eff)/25, 'kx');
	text(hires_torques_Nm(eff == max(eff)), max(eff)/25 + .075, num2str(max(eff)));
	
	%     xyt([e.name ' Torque at Idle, ' num2str(e.idle_speed_radps.table(1) * unit_convert.radps2rpm) ' RPM'],'Efficiency (%)');
	%     text(-40,47,['Disp [L]: ' num2str(e.displacement_L)]);
	%     text(-40,45,['Inertia [kg-m^2]: ' num2str(e.inertia_kgm2)]);
	%     text(-40,43,['Speed [RPM]: ' num2str(e.idle_speed_radps.table(1) * unit_convert.radps2rpm)]);
	%     text(-40,41,['Motoring Torque [Nm]: ' num2str(interp1(e.min_curve_speed_radps, e.min_curve_torque_Nm,e.idle_speed_radps.table(1),'linear','extrap'))]);
	%     vlineat(interp1(e.min_curve_speed_radps, e.min_curve_torque_Nm,e.idle_speed_radps.table(1),'linear','extrap'),'r--');
	%     vlineat(interp1(e.max_curve_speed_radps, e.max_curve_torque_Nm,e.idle_speed_radps.table(1),'linear','extrap'),'r--');
	%     legend off;
	%     ylim([0 50]);
	%     xlim([-50 250]);
	
	vlineat(interp1(e.min_curve_speed_radps, e.min_curve_torque_Nm,e.idle_speed_radps.table(1),'linear','extrap'),'r--');
	vlineat(interp1(e.max_curve_speed_radps, e.max_curve_torque_Nm,e.idle_speed_radps.table(1),'linear','extrap'),'r--');
	
	legend('Fuel Rate','Eff. div 25','Torque Limits');
	
end

if show_matrix_min_speeds
	vlineat(REVS_calc_engine_power_speed(e, 0.12, 'min') * unit_convert.radps2rpm,'r');
	vlineat(REVS_calc_engine_power_speed(e, 0.18, 'min') * unit_convert.radps2rpm,'r');
end

end

function bmep_axis_callback(src,evt, ax, ax2, scale)

ylim(ax2, ylim(ax) *  scale);

new_pos = get(ax,'Position');
new_pos(1) = new_pos(1) - 0.05; % Shift Left
new_pos(3) = 0.001; % Make Super Skinny
set(ax2,'Position',new_pos);


end

function out = set_if_empty( in, empty_val)

if isempty(in)
	out = empty_val;
else
	out = in;
end

end