function varargout = REVS_plot_transmission(transmission,plot_type,varargin)
no_figure                   = parse_varargs(varargin,'no_figure',(false),'toggle');
contour_levels              = parse_varargs(varargin,'contours',[],'numeric',{'vector'});
contour_filled              = parse_varargs(varargin,'filled',false,'toggle');
contour_labels              = parse_varargs(varargin,'no_contour_labels',true,'toggle');
contour_width               = parse_varargs(varargin,'contour_width',1,'numeric');
contour_color               = parse_varargs(varargin,'contour_color','auto');
contour_cmap                = parse_varargs(varargin,'colormap','jet','colormap');

time_range					= parse_varargs(varargin,'time_range',[]);

heatmap_data				= parse_varargs(varargin,'heatmap',[]);
heatmap_integrate			= parse_varargs(varargin,'heatmap_type','','char');
heatmap_time_range			= parse_varargs(varargin,'heatmap_time_range',time_range);
heatmap_point_select		= parse_varargs(varargin,'heatmap_point_select',[]);

data_points_data			= parse_varargs(varargin,'data_points',[]);
data_points_decimation		= parse_varargs(varargin,'data_points_decimation',1);
data_points_time_range		= parse_varargs(varargin,'data_points_time_range',time_range);

title_str                   = parse_varargs(varargin,'title','','string');

grid_input_speeds_rpm       = parse_varargs(varargin,'input_speeds', 100:100:4000);
grid_input_torques_Nm       = parse_varargs(varargin,'torques',transmission.rated_torque_Nm * [0,0.01,.02,.05:.05:1.1]);


temperature_degC = [];



%%
if strcmpi(plot_type,'EFFICIENCY') || strcmpi(plot_type,'EFF')
    plot_type = 'Efficiency (%)';
    contour_levels = set_if_empty(contour_levels,100 * [0.10 0.30 0.50 .60 .70 .75 .775 .80:.01:.89 .90:.005:1.0]);
elseif strcmpi(plot_type,'POWER LOSS')
    plot_type = 'Power Loss (W)';
    contour_levels = set_if_empty(contour_levels,500:500:4000);
elseif strcmpi(plot_type,'TORQUE LOSS')
    plot_type = 'Torque Loss at Input (Nm)';
    contour_levels = set_if_empty(contour_levels,0:1:(transmission.rated_torque_Nm*0.30));
elseif strcmpi(plot_type,'GEARBOX INPUT TORQUE LOSS')
    plot_type = 'Gearbox Input Torque Loss (Nm)';
    contour_levels = set_if_empty(contour_levels,0:0.5:(transmission.rated_torque_Nm*0.20));
elseif strcmpi(plot_type,'PUMP TORQUE LOSS')
    plot_type = 'Pump Torque Loss (Nm)';
    contour_levels = set_if_empty(contour_levels,0:0.5:(transmission.rated_torque_Nm*0.20));
elseif strcmpi(plot_type,'GEARBOX OUTPUT TORQUE LOSS')
    plot_type = 'Gearbox Output Torque Loss (Nm)';
    contour_levels = set_if_empty(contour_levels,0:0.5:(transmission.rated_torque_Nm*0.20));
else
    error('Undefined plot type ''%s''.',plot_type);
end


%% setup gb_test limits


%Gears
if transmission.type == enum_transmission_type.CVT
    test_gears           = sort([1 linspace(transmission.gear.ratio(3), transmission.gear.ratio(2), 6)]); % linspace the ratios and include 1:1
    test_ratios         = test_gears;
else
    test_gears           = transmission.gear.number(2:end);
    test_ratios         = transmission.gear.ratio(2:end);
end


%% Initialize
grid_dims = [length(grid_input_torques_Nm),length(grid_input_speeds_rpm)];

%% Setup signal_mapping
gb_test = containers.Map();


% Set up connections and constants
gb_test('trans.gb.gb_gear_engaged') = 1.0;
gb_test('driver.driver_brk_norm') = 0.0;


if ~isempty(temperature_degC)
    gb_test('trans.thermal.trans_temp_degC') = thermal;
elseif strcmpi(transmission.thermal.variant,'constant temperature')
    gb_test('trans.thermal.trans_temp_degC') = transmission.thermal.temperature_degC;
end


gb_test('iner_in_kgm2') = zeros(grid_dims);



%% Loop through each gear
for gear_idx = 1:length(test_gears)
    
  
    %Set gear-constant variables   
    gb_test('gear_num') = test_gears(gear_idx);%repmat(test_gears(gear_idx) , grid_dims);
    gb_test('trans.ctrl.gear_num') = gb_test('gear_num');
    gb_test('trans.gb.gb_curr_gear') = gb_test('gear_num');
    gb_test('trans.gb.gb_cmd_gear') = gb_test('gear_num');
    
    gb_test('gear_ratio') = test_ratios(gear_idx);%repmat(test_ratios(gear_idx), grid_dims);
    gb_test('gb_cmd_ratio') = gb_test('gear_ratio');
        
    % In Torque - Initially assume TC lockup
    gb_test('trans.trans_trq_in_Nm') = repmat(grid_input_torques_Nm(:), 1, grid_dims(2));
    gb_test('trans.gb.gb_trq_in_Nm') = gb_test('trans.trans_trq_in_Nm');
    gb_test('trans.trq_conv.tc_trq_in_Nm') =  gb_test('trans.trans_trq_in_Nm');
    gb_test('trans.trq_conv.tc_trq_out_Nm') =  gb_test('trans.trans_trq_in_Nm');
    gb_test('engine.eng_load_Nm') =  gb_test('trans.trans_trq_in_Nm');
    
    % In Speed  - Initially assume TC lockup
    gb_test('trans.trans_spd_in_rpm') = repmat(grid_input_speeds_rpm(:)', grid_dims(1), 1) ;
    gb_test('trans.trans_spd_in_radps') = gb_test('trans.trans_spd_in_rpm') .* unit_convert.rpm2radps; 
    gb_test('trans.trq_conv.tc_spd_in_radps') =  gb_test('trans.trans_spd_in_radps');
    gb_test('trans.trq_conv.tcspd_out_radps') =  gb_test('trans.trans_spd_in_radps');
    gb_test('trans.gb.gb_spd_in_radps') = gb_test('trans.trans_spd_in_radps');
       
    % Out Speed - Just assume gear ratio
    gb_test('trans.gb.gb_spd_out_radps') = gb_test('trans.gb.gb_spd_in_radps') ./ gb_test('gear_ratio');  %depends on gear ratio
    gb_test('trans.trans_spd_out_radps') = gb_test('trans.gb.gb_spd_out_radps');
    gb_test('trans.trans_spd_out_rpm') = gb_test('trans.trans_spd_out_radps') .* unit_convert.radps2rpm;                          %
    
    gb_test('vehicle.veh_spd_mps') =  gb_test('trans.trans_spd_out_radps') / 100;
        
    if transmission.type == enum_transmission_type.CVT || transmission.type == enum_transmission_type.automatic
        % Line Pressure Control Lookup
        gb_test('trans.ctrl.gb_line_press_bar') = interp_dyn_lookup( transmission.control.line_pressure_map_bar, gb_test);
        
        % pump loss lookup
        gb_test('pump_loss_Nm') =interp_dyn_lookup( transmission.pump_loss_Nm, gb_test);
        
        % torque loss
        gb_test('trans.gb.gb_trq_in_Nm') = (gb_test('trans.trq_conv.tc_trq_in_Nm') - gb_test('pump_loss_Nm')) * transmission.torque_converter.lockup_efficiency_norm;
        gb_test('trans.trq_conv.tc_trq_out_Nm') = gb_test('trans.gb.gb_trq_in_Nm');
    end
    
    
    %% Gearbox
    
    % Input torque loss
    gb_test('input_torque_loss_Nm') = interp_dyn_lookup( transmission.gear.input_torque_loss_Nm, gb_test);
    
    %Gear efficiency
    gb_test('trans.gb.gb_sync_trq_out_Nm') = gb_test('trans.gb.gb_trq_in_Nm') - gb_test('input_torque_loss_Nm');   
    
    gb_test('gear_efficiency') = interp_dyn_lookup( transmission.gear.efficiency_norm, gb_test) .^ sign(gb_test('trans.gb.gb_sync_trq_out_Nm'));
        
    %Output torque loss
    gb_test('output_torque_loss_Nm') = interp_dyn_lookup( transmission.gear.output_torque_loss_Nm, gb_test);    
    gb_test('trans.gb.gb_trq_out_Nm') = gb_test('trans.gb.gb_sync_trq_out_Nm') .* gb_test('gear_efficiency') * gb_test('gear_ratio') - gb_test('output_torque_loss_Nm');
    gb_test('trans.trans_trq_out_Nm') = gb_test('trans.gb.gb_trq_out_Nm');
    
%     %% Post Gearbox
%     
%     %FDR eff
%     gb_test(gear_idx).driveline_output_torque_Nm = gb_test(gear_idx).trq_out_Nm .* vehicle.drive_axle1.final_drive.efficiency_norm;
%     gb_test(gear_idx).spd_out_radps = repmat(gb_test(gear_idx).spd_out_radps,gb_test(gear_idx).test_dims(1),1);
%     gb_test(gear_idx).driveline_efficiency_norm = (gb_test(gear_idx).driveline_output_torque_Nm.*gb_test(gear_idx).spd_out_radps)./(gb_test(gear_idx).gb_spd_in_radps.*gb_test(gear_idx).input_torque_Nm);
%     gb_test(gear_idx).power_loss = (gb_test(gear_idx).gb_spd_in_radps.*gb_test(gear_idx).input_torque_Nm) - (gb_test(gear_idx).driveline_output_torque_Nm.*gb_test(gear_idx).spd_out_radps);
%     
    

    if nargout > 0
        results{gear_idx} = gb_test;
    end

%% contour plots at constant gear ratio
    
    
    if strcmp(plot_type,'Efficiency (%)')
        plot_data = 100 * (gb_test('trans.trans_trq_out_Nm') .* gb_test('trans.trans_spd_out_radps')) ./ (gb_test('trans.trans_trq_in_Nm') .* gb_test('trans.trans_spd_in_radps'));
    elseif strcmp(plot_type,'Power Loss (W)')
        plot_data =  (gb_test('trans.trans_trq_in_Nm') .* gb_test('trans.trans_spd_in_radps')) - (gb_test('trans.trans_trq_out_Nm') .* gb_test('trans.trans_spd_out_radps'));
    elseif strcmp(plot_type,'Torque Loss at Input (Nm)')
        plot_data =  gb_test('trans.trans_trq_in_Nm') - (gb_test('trans.trans_trq_out_Nm') .* gb_test('trans.trans_spd_out_radps') ./ gb_test('trans.trans_spd_in_radps'));
        
    elseif strcmp(plot_type,'Pump Torque Loss (Nm)')
        plot_data =  gb_test('pump_loss_Nm');    
        
    elseif strcmp(plot_type,'Gearbox Input Torque Loss (Nm)')
        plot_data =  gb_test('input_torque_loss_Nm');

    elseif strcmp(plot_type,'Gearbox Output Torque Loss (Nm)')
        plot_data =  gb_test('output_torque_loss_Nm');   
    
    end
        
    % Additional Contour Plotting Arguments
    addtl_args = { 'linewidth',contour_width, 'color', contour_color};
    
    if no_figure
        fig = gcf;
        ax = gca;
    else
        fig = figure;
        ax = axes;
    end
    
    % Plot
    if contour_filled
        [C,h] = contourf(gb_test('trans.trans_spd_in_rpm'), gb_test('trans.trans_trq_in_Nm'), plot_data, contour_levels,addtl_args{:});
    else
        [C,h] = contour(gb_test('trans.trans_spd_in_rpm'), gb_test('trans.trans_trq_in_Nm'), plot_data, contour_levels,addtl_args{:});
    end
    
    %assignin('base','h',h)
    cmap = contour_cmap;
    if ischar( cmap)
        cmap = eval(cmap);
    end
    
    % Linearize colormap based on contour levels
    contour_levels_norm = unique((contour_levels - min(contour_levels)) ./ ( max(contour_levels) - min(contour_levels)));
    cmap_convert = interp1( contour_levels_norm, linspace(0,1,length(contour_levels_norm)), linspace(0,1,size(cmap,1)));
    cmap = interp1( linspace(0,1,size(cmap,1)),cmap, cmap_convert);
    colormap(cmap);
    
    if contour_labels
        clabel(C,h,'labelspacing',144,'color',[0.5,0.5,0.5],'fontweight','bold')
    end
    
    hold on
    
    % Plot heat map overlay
    if ~isempty(heatmap_data)
		REVS_plot_transmission_heatmap_overlay( heatmap_data, 'heatmap_type', heatmap_integrate, 'heatmap_time_range', heatmap_time_range, 'heatmap_point_select', heatmap_point_select, 'heatmap_gear_select', gb_test('gear_num') );
	end
    
    % Plot operational data point cloud
    if ~isempty( data_points_data)
        if isa(data_points_data,'class_test_data')
            
            % select variables from class_test_data
            data_points_torque = data_points_data.engine.crankshaft_torque_Nm;
            data_points_speed = data_points_data.engine.speed_rpm;
            data_points_time = data_points_data.time;
            
            if ~isempty( data_points_label )
                data_points_value = data_points_data.engine.crankshaft_power_kW;
            end
            
        elseif isstruct(data_points_data) && isfield(data_points_data,'mech') && isfield( data_points_data.mech, 'engine')
            
            % select variables form audit structure
            data_points_torque = data_points_data.mech.engine.crankshaft_torque_Nm;
            data_points_speed = data_points_data.mech.engine.speed_rpm;
            data_points_time = data_points_data.time;
            
            if ~isempty( data_points_label )
                data_points_value = data_points_data.mech.engine.crankshaft_power_kW;
            end
            
        end
        
        pts_idx = 1:data_points_decimation:length( data_points_speed);
        if ~isempty( data_points_time_range )
            pts_idx( data_points_time(pts_idx) < data_points_time_range(1)) = [];
            pts_idx( data_points_time(pts_idx) > data_points_time_range(end)) = [];
        end
        
        plothg( data_points_speed(pts_idx), data_points_torque(pts_idx), 'r.','MarkerSize',1 )
        if ~isempty( data_points_value )
            %TODO: Add value labels
        end
    end
    

    % Finish presentation
    grid on;
    
    %Labels
    xlabel('Input Speed (RPM)');
    ylabel('Input Torque (Nm)');
    if isempty(title_str)
        title_str_out = sprintf('%s %s\nGear %d', transmission.name, plot_type, gb_test('gear_num'));
    else
        title_str_out = sprintf('%s\nGear %d', title_str, gb_test('gear_num'));        
    end
    title(title_str_out, 'Interpreter','none');
    
    xlim(grid_input_speeds_rpm([1,end]));
        

    
end

% Provide data if requested
if nargout > 0
    varargout{1} = results;
end


end

function result = interp_dyn_lookup( dyn_lookup, signal_map)

    needed_signals  = dyn_lookup.get_signal_array();
    signal_list = signal_map.keys();
    lookup_args = {};
    
    for i = 1:length(needed_signals)
        
       sig = needed_signals{i};
       
       hit = endsWith(signal_list,sig);
       
       if sum(hit) ~= 1
           error('Unable to determine value for %s', sig)
       end
       
       lookup_args{end+1} = sig;
       lookup_args{end+1} = signal_map(signal_list{hit});
                
    end
    
    result = dyn_lookup.interp(lookup_args{:});

end




function out = set_if_empty( in, empty_val)

if isempty(in)
    out = empty_val;
else
    out = in;
end

end

