function [ch] = REVS_plot_transmission_heatmap_overlay( heatmap_data, varargin )

heatmap_integrate			= parse_varargs(varargin,'heatmap_type','','char');
heatmap_time_range			= parse_varargs(varargin,'heatmap_time_range',[]);
heatmap_point_select		= parse_varargs(varargin,'heatmap_point_select',[]);
heatmap_gear_select         = parse_varargs(varargin,'heatmap_gear_select',[]);

heatmap_gear = [];

if isa(heatmap_data,'class_test_data') && ...
        any( ~isnan(heatmap_data.transmission.gearbox_input_speed_rpm) ) && any( ~isnan(heatmap_data.transmission.gearbox_input_torque_Nm) )
    
    % select variables from class_test_data
    heatmap_speed = heatmap_data.transmission.gearbox_input_speed_rpm;
    heatmap_time = heatmap_data.time;
    heatmap_torque = heatmap_data.transmission.gearbox_input_torque_Nm;
    heatmap_gear = heatmap_data.transmission.current_gear_number;
    
    if ~isempty( heatmap_integrate )
        heatmap_value = eval(['heatmap_data.transmission.', heatmap_integrate]);
    end
    
elseif isa(heatmap_data,'class_test_data') && ...
        any( ~isnan(heatmap_data.engine.speed_rpm) ) && any( ~isnan(heatmap_data.engine.crankshaft_torque_Nm) )
    
    warning('Using engine speed and torque data which may shift operation when torque conterter is unlocked');
    
    % select variables from class_test_data
    heatmap_speed = heatmap_data.engine.speed_rpm;
    heatmap_time = heatmap_data.time;
    heatmap_torque = heatmap_data.engine.crankshaft_torque_Nm;
    heatmap_gear = heatmap_data.transmission.current_gear_number;
    
    if ~isempty( heatmap_integrate )
        heatmap_value = eval(['heatmap_data.engine.', heatmap_integrate]);
    end
    
elseif isa(heatmap_data,'class_transmission_data')
    
    % select variables from class_test_data
    heatmap_speed = heatmap_data.input_speed_rpm;
    heatmap_time = heatmap_data.time;
    heatmap_torque = heatmap_data.input_torque_Nm;
    heatmap_gear = heatmap_data.current_gear_number;
    
    if ~isempty( heatmap_integrate )
        heatmap_value = eval(['heatmap_data.', heatmap_integrate]);
    end
        
elseif isa(heatmap_data,'class_REVS_datalog') &&  isprop( heatmap_data, 'transmission') &&  isprop( heatmap_data.transmission, 'gearbox')
    
    % select variables form datalog structure
    heatmap_speed = heatmap_data.transmission.gearbox.input_spd_rpm;
    heatmap_torque = heatmap_data.transmission.gearbox.input_trq_Nm;
    heatmap_time = heatmap_data.time;
    heatmap_gear = heatmap_data.transmission.current_gear;
    
    if ~isempty( heatmap_integrate )
        heatmap_value = eval(['heatmap_data.', heatmap_integrate]);
    end
    
elseif isa(heatmap_data,'class_REVS_datalog') &&  isprop( heatmap_data, 'engine')
    
    warning('Using engine speed and torque data which may shift operation when torque conterter is unlocked');
    
    % select variables form datalog structure
    heatmap_torque = heatmap_data.engine.crankshaft_trq_Nm;
    heatmap_time = heatmap_data.time;
    heatmap_speed = heatmap_data.engine.crankshaft_spd_rpm;
    heatmap_gear = heatmap_data.transmission.current_gear;
        
    if ~isempty( heatmap_integrate )
        heatmap_value = eval(['heatmap_data.', heatmap_integrate]);
    end
    
else
    
    error('Unknown heatmap data format. Must be a class_test_data or class_REVS_datalog containing necessary signals');
    
end


if isempty(heatmap_integrate)
    heatmap_value = heatmap_torque .* heatmap_speed / 9549.3;
end

% Remove energy from excluded region
if ~isempty( heatmap_time_range)
    heatmap_value( heatmap_time < heatmap_time_range(1) ) = 0;
    heatmap_value( heatmap_time > heatmap_time_range(end) ) = 0;
end

if ~isempty(heatmap_point_select)
    heatmap_value( ~heatmap_point_select ) = 0;
end

if isempty(heatmap_gear_select) 
    % nothing to do
elseif all( isnan( heatmap_gear ) )
    warning('Gear data unavailable, using heatmap for all gears')
else
    heatmap_value( ismember( heatmap_gear, heatmap_gear_select) ) = 0;
end


heatmap_value = max( 0,heatmap_value );

caxis_min = interp1([2,length(jet)+1], caxis, 1,'linear','extrap');
caxis_max = max(caxis);
min_torque = min( ylim );
max_torque = max( ylim );

[~,ch] = newhist2d(heatmap_speed, linspace(0,6500,40), heatmap_torque, linspace(min_torque,max_torque,30), heatmap_value, heatmap_time,caxis_min, caxis_max);

shading interp;

ch.ZData = ch.ZData-2;
alpha(ch, 0.65);
colormap([1,1,1; jet])

caxis([caxis_min, caxis_max]);

end