function [] = collate_csv_files(filepath, output_filepathname, varargin)
% function [] = collate_results_files(filepath, output_filepathname)
%   Collate .csv files from the given filepath into the output file

    start_path = pwd;

    cd(filepath)

    dir_info = dir('*.csv');

    csv_files = {dir_info.name};

    csv_files = strcat({filepath}, {filesep}, csv_files);

    if ~endsWith('.csv', output_filepathname)
        output_filepathname = strcat(output_filepathname, '.csv');
    end
    
    collate_files(csv_files, output_filepathname, varargin{:})
         
    cd(start_path);
    
end
