function [] = collate_files(files, output_filepathname, varargin)
% function [] = collate_files(files, output_path, output_filename)
%   Collate the given files into a single file with the output_filename at
%   the output_path
%
% Optional Arguments
%   header_rows = parse_varargs(varargin, 'header_rows', 2); % number of header rows, copied from the first input file

header_rows = parse_varargs(varargin, 'header_rows', 2); % number of header rows, copied from the first input file
pause(5);
output_fid = fopen(output_filepathname,'w+');
[input_fid, err_msg]  = fopen(files{1});

% copy header
for i = 1:header_rows
    fprintf(output_fid, '%s\n', fgetl(input_fid));
end

fclose(input_fid);

for f = 1:length(files)
    input_fid = fopen(files{f});
    
    for i = 1:header_rows
        fgetl(input_fid);   % skip line
    end

    tline = fgetl(input_fid);
    while ischar(tline)
        fprintf(output_fid, '%s\n', tline);
        tline = fgetl(input_fid);
    end
    fclose(input_fid);
end

fclose(output_fid);
