

function sigs_out = expand_bus_signals(sigs_in)


if ischar( sigs_in)
	
	sigs_out = sigs_in;
	
elseif iscellstr( sigs_in )
	
	sigs_out = sigs_in;

elseif size( sigs_in, 2) > 1  

	branches = expand_sigs(sigs_in{2});
	
	root = sigs_in{1};
	
	sigs_out = strcat( root, {'.'}, branches);
	
	
else
	
	sigs_out = {};
	
	for s = 1:length( sigs_in) 
	
		sig = expand_sigs( sigs_in{s} );
		
		sigs_out = vertcat( sigs_out, sig);
	
	end
end

end
