function found = findWorkspace(functionHandle)
%findWorkspace
%   returns cell array of strings of var names in all of workspace that satisfy the function
%   handle
%   ex: findWorkspace(@(n) any(isnan(n))) searches for variables that
%   contain nans

    %find all variables and member variables
    varNames = levelWorkspace('all');
    
    found = [];

    for i = 1:length(varNames)    
        try %Needed for when the function handle is incompatible with variable
           if(functionHandle(evalin('caller',varNames{i})))
               found = [found;{varNames{i}}];
           end       
        catch
            fprintf('%s Incompatible with function handle. skipped.\n',varNames{i});
        end
    end
end


function  allVars = levelWorkspace(vars , varargin)
%levelWorkspace - returns a 1xN cell array containing names of all the variables and
%member variables within vars

%levelWorkspace('all') searches entire workspace

%   Write workspace variables to a cell array
create_constructors = parse_varargs(varargin,'class_constructors',true,'toggle');
sort_fieldnames = parse_varargs(varargin,'sort_fieldnames',true,'toggle');
sort_properties = parse_varargs(varargin,'sort_properties',false,'toggle');

%TODO: Add support for newlines within strings
if nargin == 1 || (ischar(vars) && strcmp( vars,'all'))
    vars = evalin('base','who');
end


all_var_list = [];

for v = 1:length(vars)
    
    var_list = vars(v);
    
    var_list_idx = 1;
    while var_list_idx <= length(var_list)
        
        var_current = var_list{var_list_idx};
        
        if( evalin('base',['iscell( ',var_current ,') && ~isempty( ',var_current, ');']) )
            % Cell Array
            
            dims = evalin('base',['size( ',var_current, ');'] );
            idxs_str = cellstr(int2str(REVS_fullfact(dims)));
            idxs_str = regexprep(strtrim(idxs_str ),'\s*',',');
            add_fields = strcat(var_current ,'{' , idxs_str,'}' );
            var_list = {var_list{:}, add_fields{:}};
            
            var_list(var_list_idx) = [];	% Remove Root
            
        elseif( evalin('base',['isstruct( ',var_current ,') && (numel( ',var_current,') > 1);'])  )
            % Array of structs
            dims = evalin('base',['size( ',var_current, ');'] );
            idxs_str = cellstr(int2str(REVS_fullfact(dims)));
            idxs_str = regexprep(strtrim(idxs_str) ,'\s*',',');
            add_fields = strcat(var_current ,'(' , idxs_str,')' );
            var_list = {var_list{1:var_list_idx}, add_fields{:}, var_list{(var_list_idx+1):end}};
            var_list(var_list_idx) = [];	% Remove Root
            
        elseif( evalin('base',['isstruct( ',var_current ,');']) )
            % Struct
            
            field_names = evalin('base',['fieldnames( ',var_current, ');'] );
            if sort_fieldnames
                field_names = sort(field_names);
            end
            add_fields = strcat(var_current , '.', field_names);
            var_list = {var_list{1:var_list_idx}, add_fields{:}, var_list{(var_list_idx+1):end}};
            var_list(var_list_idx) = []; % Remove Root from list
        elseif( evalin('base',['isobject( ',var_list{var_list_idx} ,');']) ) && create_constructors
            % Classes w/ constructor call
            
            class_info = evalin('base',['metaclass( ',var_current, ');'] );
            
            property_mask = ~[class_info.PropertyList.Hidden] & ~[class_info.PropertyList.Dependent];
            property_names = {class_info.PropertyList.Name};
            property_names = property_names(property_mask);
            if sort_properties
                property_names = sort(property_names);
            end
            
            add_fields = strcat(var_current ,'.' , property_names );
            var_list = {var_list{1:var_list_idx}, add_fields{:}, var_list{(var_list_idx+1):end}};
            var_list_idx = var_list_idx+1;
        elseif( evalin('base',['isobject( ',var_list{var_list_idx} ,');']) )
            % Calss w/o constructor call - > will make a struct
            
            class_info = evalin('base',['metaclass( ',var_current, ');'] );
            property_mask = ~[class_info.PropertyList.Hidden];
            property_names = {class_info.PropertyList.Name};
            property_names = property_names(property_mask);
            if sort_properties
                property_names = sort(property_names);
            end
            
            add_fields = strcat(var_current ,'.' , property_names );
            var_list = {var_list{1:var_list_idx}, add_fields{:}, var_list{(var_list_idx+1):end}};
            var_list(var_list_idx) = []; % Remove root ( constructor )
            
        else
            var_list_idx = var_list_idx+1;
        end
        
    end
    
    
    all_var_list = [all_var_list,var_list]; 
    
end

%set to a cell just in case of a single var (char vector)
allVars = cell(all_var_list);
end
%Credit: basically just Paul's work


function out = REVS_fullfact(in)
if(iscolumn(in))
    in = in';
elseif(size(in,1) > 1)
    error('improper input, must be 1xN vector');
end

outLength = prod(in);

out = zeros(outLength,length(in));

for i = 1:length(in)
    repNum = outLength / in(i);
    out(:,i) = repmat((1:in(i))',repNum,1);
end
end






