function git_info = get_git_info()


    [r, branch] = system('git branch --show-current');
    git_info.branch = strtrim(branch);
    
    [r, commit_info] = system('git log -1');
    
    git_info.prev_commit = regexp(commit_info, '(?<=commit\s+)\w+','match','once');
    git_info.prev_commit_author = regexp(commit_info, '(?<=Author:\s+)[^\n]*','match','once');
    
    
    [r, files] = system('git status --porcelain');
    files = regexp(files, '(?<status>..) (?<file>.*)','tokens','dotexceptnewline')';
    git_info.uncomitted = cell2table(reshape([files{:}],2,[])','VariableNames',{'Status','File'});


end