function [ new_vehicle ] = matrix_calc_roadload( vehicle, weight_reduction_norm, improve_aero_norm, improve_crr_norm, varargin)
do_plots = parse_varargs(varargin,'do_plots',false,'toggle');

new_vehicle = vehicle;

%Apply to Cd & Crr
new_vehicle.aerodynamic_drag_coeff                          = vehicle.aerodynamic_drag_coeff * (1 - improve_aero_norm);
new_vehicle.drive_axle1.tire.rolling_resistance_coefficient = vehicle.drive_axle1.tire.rolling_resistance_coefficient * (1 - improve_crr_norm);

% Dan Method 2008 CRR = 0.01
new_vehicle.coastdown_target_A_N	 = vehicle.coastdown_target_A_N - 0.01 * 9.8 * vehicle.mass_static_kg * ( 1 -  (1 - weight_reduction_norm) * (1 - improve_crr_norm) ) ;
new_vehicle.coastdown_target_B_Npms  = vehicle.coastdown_target_B_Npms;
new_vehicle.coastdown_target_C_Npms2 = vehicle.coastdown_target_C_Npms2 * (1- improve_aero_norm);

%if weight_reduction_norm > 0
	new_vehicle.mass_curb_kg = vehicle.mass_curb_kg * (1 - weight_reduction_norm);
%end

if do_plots
    vspeed_mph = 0:70;
    
    [base_roadload_force_N, base_roadload_power_kW, ~, ~] = calc_roadload_abc_N(vehicle.coastdown_target_A_N, vehicle.coastdown_target_B_Npms, vehicle.coastdown_target_C_Npms2, vspeed_mph);
    [new_roadload_force_N, new_roadload_power_kW, ~, ~] = calc_roadload_abc_N(new_vehicle.coastdown_target_A_N, new_vehicle.coastdown_target_B_Npms, new_vehicle.coastdown_target_C_Npms2, vspeed_mph);
    
    fplothg(vspeed_mph * unit_convert.mph2mps, base_roadload_force_N);
    plothg(vspeed_mph * unit_convert.mph2mps, new_roadload_force_N,'r.-');
    xyt('m/s','Roadload Force (N)');
    
    fplothg(vspeed_mph * unit_convert.mph2mps, base_roadload_power_kW);
    plothg(vspeed_mph * unit_convert.mph2mps, new_roadload_power_kW,'r.-');
    xyt('m/s','Roadload Power (kW)');
end

end

