function write_REVS_engine( file, engine, varargin)
%write_REVS_engine Summary of this function goes here
%   Detailed explanation goes here

show_file = parse_varargs( varargin,'show_file',false,'toggle');
% citation = parse_varargs( varargin,'no_citation',true,'toggle');

fid = fopen( file ,'w+');

% Disable auto calculation in getter functions
engine.disable_auto_calc = true;

warning('write_REVS_engine is deprecated and will be remove in a future release, replace with write_mscript class methood.');


%% Write to m-file
fprintf( fid,'%% ALPHA ENGINE DEFINITION\n'); 
fprintf( fid,'%% Generated %s\n',datestr(now)); 

% if citation
% 	fprintf( fid,'%% SUGGESTED CITATION: \n%% %s - Full Engine Map Package. Version %s. Ann Arbor MI: US EPA National Vehicle and Fuel Emissions Laboratory, National Center for Advanced Technology, %s\n',engine.name, datestr(now(),'yyyy-mm-dd'), datestr(now(),'yyyy')); 
% end



fprintf( fid,'\n%% Constructor\n'); 
fprintf( fid,'engine = %s();\n', class(engine) );
fprintf( fid, gen_property_str(engine,'name') );
fprintf( fid, 'engine.source_filename = mfilename;');

fprintf( fid, gen_property_str(engine,'matrix_vintage') );

fprintf( fid,'\n%% Physical Description\n');
fprintf(fid, gen_property_str(engine,'displacement_L'));
fprintf(fid, gen_property_str(engine,'num_cylinders'));
fprintf(fid, gen_property_str(engine,'combustion_type'));
fprintf(fid, gen_property_str(engine,'compression_ratio'));
fprintf(fid, gen_property_str(engine,'inertia_kgm2'));
fprintf(fid, gen_property_str(engine,'bore_mm'));
fprintf(fid, gen_property_str(engine,'stroke_mm'));


fprintf( fid, '\n%% Maximum Torque Curve\n');
fprintf(fid, gen_property_str(engine,'full_throttle_speed_radps')); 
fprintf(fid, gen_property_str(engine,'full_throttle_torque_Nm'));

if ~isequal(engine.full_throttle_speed_radps, engine.naturally_aspirated_speed_radps) || any( engine.full_throttle_torque_Nm(:) > engine.naturally_aspirated_torque_Nm(:) )
	fprintf(fid, gen_property_str(engine,'naturally_aspirated_speed_radps')); 
	fprintf(fid, gen_property_str(engine,'naturally_aspirated_torque_Nm'));
end


fprintf( fid, '\n%% Minimum Torque Curve\n');
fprintf(fid, gen_property_str(engine,'closed_throttle_speed_radps'));
fprintf(fid, gen_property_str(engine,'closed_throttle_torque_Nm'));

fprintf( fid, '\n%% Fuel Map\n');
fprintf(fid, gen_property_str(engine,'fuel_map_speed_radps'));
fprintf(fid, gen_property_str(engine,'fuel_map_torque_Nm'));
fprintf(fid, gen_property_str(engine,'fuel_map_gps'));

fprintf(fid, gen_property_str(engine,'deac_fuel_map_gps'));


fprintf( fid, '\n%% Fuel Properties\n');
if class_REVS_fuel.check_id(engine.fuel.id)
	fprintf(fid, 'engine.fuel = class_REVS_fuel(''%s'');\n', engine.fuel.id);
else
	% Not in table write individual fields
	fprintf(fid, gen_property_str(engine,'fuel'));
end

fprintf( fid, '\n%% Idle Speed\n');
fprintf(fid, gen_property_str(engine,'idle_speed_radps'));

fprintf( fid, '\n%% Pedal Calibration\n');
fprintf(fid, gen_property_str(engine,'pedal_map_type'));
if engine.pedal_map_type == enum_engine_pedal_map_type.lookup_table
	 fprintf(fid, gen_property_str(engine,'pedal_map_speed_radps'));
	 fprintf(fid, gen_property_str(engine,'pedal_map_pedal_norm'));
	 fprintf(fid, gen_property_str(engine,'ipedal_map_Nm'));
end

fprintf( fid, '\n%% Calibration Adjustment Factors\n');

% Print any additional non-default values
completed_props = {'name','matrix_vintage',...
	'displacement_L','combustion_type','compression_ratio', 'inertia_kgm2','bore_mm','stroke_mm','num_cylinders',...
	'full_throttle_speed_radps','full_throttle_torque_Nm','naturally_aspirated_speed_radps','naturally_aspirated_torque_Nm',...
	'closed_throttle_speed_radps','closed_throttle_torque_Nm',...
	'fuel_map_speed_radps','fuel_map_torque_Nm','fuel_map_gps','deac_fuel_map_gps',...
	'fuel','idle_speed_radps',...
	'pedal_map_type','pedal_map_speed_radps','pedal_map_pedal_norm','pedal_map_Nm'};
class_meta = metaclass(engine);
prop_meta = class_meta.PropertyList;
calibration_props = 0;

for p = 1:length(prop_meta)

	prop = prop_meta(p).Name;
	
	if ismember( prop, completed_props) 
		% Skip it already done
	elseif prop_meta(p).Hidden || prop_meta(p).Constant || prop_meta(p).Transient || prop_meta(p).Dependent
		% Skip it
	elseif prop_meta(p).HasDefault && isequal(engine.(prop), prop_meta(p).DefaultValue)
		% Skip It - same as default
	else	
		prop_str = gen_property_str(engine,prop);
		
		if ~isempty( prop_str)
			fprintf(fid, prop_str);
			calibration_props = calibration_props+1;
		end
	end
	
end

if calibration_props == 0
	fprintf( fid, '%% -- None -- \n');
end


if show_file
	fprintf( 'Generated file: %s\n\n',file) ;
	fseek(fid,0,'bof');
	line = 1;
	while ~feof(fid)
		fprintf('%i\t%s\n',line, fgetl(fid));
		line = line+1;
	end
	
end



fclose(fid);

% Allow time for the file to close before publisher tries to use it
pause(1);



end

function str = gen_property_str( engine, prop)

	val = engine.(prop);

	if ~( isobject(val) || isstruct(val) ) && ( isempty( val) ||  all(isnan(val(:))))
		str = '';
	else
		str = export2mscript(val,['engine.',prop],'exclude_empty','tab_separator');		
	end

end

