REVS_preprocess_sim_case;

%% torque converter torque ratio
if sim_config.TC_torque_ratio_auto.has_value && sim_config.TC_torque_ratio_auto.value && isprop(transmission,'torque_converter')
    
    if strcmpi(sim_config.vehicle_type.value,'"Truck"')
        transmission.torque_converter.drive_torque_ratio    = interp1([0 0.875 1],[2.3 1 1], transmission.torque_converter.speed_ratio);
    else
        transmission.torque_converter.drive_torque_ratio    = interp1([0 0.875 1],[2.2 1 1], transmission.torque_converter.speed_ratio);
    end
    
    transmission.torque_converter.decel_torque_ratio		= 0.98 * ones(size(transmission.torque_converter.speed_ratio));
    
end

if sim_config.normalize_lockup.has_value && sim_config.normalize_lockup.value && isprop(transmission,'tcc_strategy')
    if isa(transmission.tcc_strategy, 'class_REVS_uber_dynamic_lockup')
        if transmission.matrix_vintage == enum_matrix_vintage.future
            transmission.tcc_strategy.always_lock_gear = 2;
            transmission.tcc_strategy.always_unlock_gear = transmission.tcc_strategy.always_lock_gear - 1;
        elseif transmission.matrix_vintage == enum_matrix_vintage.present
            transmission.tcc_strategy.always_lock_gear = 3;
            transmission.tcc_strategy.always_unlock_gear = transmission.tcc_strategy.always_lock_gear - 1;
        else % past vintage
            transmission.tcc_strategy.always_lock_gear = min(4, transmission.gear.number(end)-1);
            transmission.tcc_strategy.always_unlock_gear = transmission.tcc_strategy.always_lock_gear - 1;
        end
        
        if transmission.gear_strategy.type == enum_transmission_gear_select.ALPHAshift
            transmission.gear_strategy.use_engine_speed_mask = zeros(size(transmission.gear.number));

            lockup_table_size = size(transmission.tcc_strategy.lock_table.table);
            for i = 1:lockup_table_size(2)
                transmission.tcc_strategy.lock_table.table(:,i) = max(transmission.gear_strategy.upshift_min_speed_radps(2:end)' ./ transmission.gear.ratio(2:end)', transmission.tcc_strategy.lock_table.table(:,i));
            end
        end
        
    else % typically CVTs would wind up here...
        if transmission.type == enum_transmission_type.CVT
            transmission.tcc_strategy = class_REVS_uber_dynamic_lockup;
            transmission.tcc_strategy.lockup_allowed = true;

            transmission.tcc_strategy.downshift_unlock_condition = '0';
            transmission.tcc_strategy.upshift_unlock_condition   = '0';

            transmission.tcc_strategy.lock_table.axis_1.signal      = 'eng_load_norm';
            transmission.tcc_strategy.lock_table.axis_1.breakpoints = [0 1];
            transmission.tcc_strategy.lock_table.table              = [0 0]; 

            transmission.tcc_strategy.unlock_table.axis_1.signal      = 'eng_load_norm';
            transmission.tcc_strategy.unlock_table.axis_1.breakpoints = [0 1];
            transmission.tcc_strategy.unlock_table.table              = [0 0]; 
            
            if transmission.matrix_vintage == enum_matrix_vintage.future
                transmission.tcc_strategy.lock_condition	= '(@veh_spd_mps > 4.5 && @gb_spd_in_radps > transmission.gear_strategy.min_speed_radps.table(1))'; % 10 MPH lockup
            elseif transmission.matrix_vintage == enum_matrix_vintage.present
                transmission.tcc_strategy.lock_condition	= '(@veh_spd_mps > 6.7 && @gb_spd_in_radps > transmission.gear_strategy.min_speed_radps.table(1))'; % 15 MPH lockup
            else % past vintage
                transmission.tcc_strategy.lock_condition	= '(@veh_spd_mps > 9 && @gb_spd_in_radps > transmission.gear_strategy.min_speed_radps.table(1))';   % 20 MPH lockup
            end

            transmission.tcc_strategy.unlock_condition	= '(@veh_spd_mps < 2.2 && @eng_spd_radps < 0.9*transmission.gear_strategy.min_speed_radps.table(1))';   % 5 MPH unlock
        end
    end
    
end

%% AUTO-AUTOSHIFT
if sim_config.normalize_shift.has_value && sim_config.normalize_shift.value
    if isa(transmission.gear_strategy, 'class_REVS_ALPHAshift')
        redline_rpm = min(engine.full_throttle_speed_radps(end) - 650 * unit_convert.rpm2radps, REVS_calc_engine_power_speed(engine, 0.98, 'max')) * unit_convert.radps2rpm;
        
        if transmission.matrix_vintage == enum_matrix_vintage.future
            transmission.gear_strategy.min_speed_radps					= [0 linspace(800 * unit_convert.rpm2radps, 1050 * unit_convert.rpm2radps, length(transmission.gear.number)-1)];
            transmission.gear_strategy.upshift_min_speed_radps			= 1050 * unit_convert.rpm2radps * ones(size(transmission.gear.number));
            transmission.gear_strategy.required_cost_benefit_ratio      = 1.03 * ones(size(transmission.gear.number));
            transmission.gear_strategy.disable_cost_saving_downshifts   = true; % false;
        else
            transmission.gear_strategy.min_speed_radps					= [0 linspace(800 * unit_convert.rpm2radps, 1200 * unit_convert.rpm2radps, length(transmission.gear.number)-1)];
            transmission.gear_strategy.upshift_min_speed_radps			= 1200 * unit_convert.rpm2radps * ones(size(transmission.gear.number));
            transmission.gear_strategy.required_cost_benefit_ratio      = 1.03 * ones(size(transmission.gear.number));
            transmission.gear_strategy.disable_cost_saving_downshifts   = true;
        end
        
        transmission.gear_strategy.min_speed_radps					= max(transmission.gear_strategy.min_speed_radps, engine.idle_speed_radps.table(1));
        
        transmission.gear_strategy.upshift_min_speed_radps			= max( transmission.gear_strategy.upshift_min_speed_radps, transmission.gear_strategy.min_speed_radps + 10);
        transmission.gear_strategy.min_speed_shift_increment        = ones(size(transmission.gear.number));
        transmission.gear_strategy.max_speed_radps					= redline_rpm * unit_convert.rpm2radps * ones(size(transmission.gear.number));
        transmission.gear_strategy.max_speed_radps(2)               = transmission.gear_strategy.max_speed_radps(2) * 0.90; % shift a little earlier in 1st gear to prevent over-rev
        transmission.gear_strategy.downshift_max_speed_radps 		= 0.80 * transmission.gear_strategy.max_speed_radps;
        transmission.gear_strategy.max_speed_shift_increment        = ones(size(transmission.gear.number));
        transmission.gear_strategy.kickdown_trigger_ratio           = interp1([0,0.5,1],[1.5,1.5,1.33], transmission.gear.number./ transmission.gear.number(end) );        
        transmission.gear_strategy.kickdown_delay_secs              = 0.05 * ones(size(transmission.gear.number));
        
        if (vehicle.powertrain_type == enum_powertrain_type.hybrid_P0) % || (vehicle.powertrain_type == enum_powertrain_type.hybrid_P2_BAS)
            transmission.gear_strategy.kickdown_trigger_ratio = min(1.25, transmission.gear_strategy.kickdown_trigger_ratio);
        end
        
        transmission.gear_strategy.upshift_min_speed_radps = max(transmission.gear_strategy.upshift_min_speed_radps, 1000 * unit_convert.rpm2radps);
        
        transmission.gear_strategy.kickdown_min_gear = 2;
        if (transmission.gear.number(end) == 4)
            transmission.gear_strategy.kickdown_max_increment = 2;
        else
            transmission.gear_strategy.kickdown_max_increment = transmission.gear.number(end)/2;
        end
    else
    end
end


%% DFCO harmonization
try % for new engines
    if exist('engine','var')
        engine.DFCO_enable_condition = '@veh_spd_mps>5';
    end
end

if sim_config.high_efficiency_alternator_regen.has_value && sim_config.high_efficiency_alternator_regen.value
    electric.battery = battery_base_lead_acid_flooded_41Ah();

    electric.alternator.regen_enable        = true;
    electric.alternator.target_voltage_V    = interp1(electric.battery.open_circuit_voltage_map_charge_V.axis_1.breakpoints, electric.battery.open_circuit_voltage_map_charge_V.table(1,:), electric.battery.initial_soc_norm);
    electric.alternator.efficiency_norm     = 0.7;
end

%% auto package name??
if ~sim_config.tech_package.has_value
    if exist('engine','var')
        sim_config.tech_package.value = strrep([engine.source_filename '.' transmission.name '.' accessories.name '.HEAR' num2str(sim_config.high_efficiency_alternator_regen.value) '.DD' num2str(sim_config.engine_deac_D_cyl_pct.value) '.DC' num2str(sim_config.engine_deac_C_cyl_pct.value) '.DS' num2str(sim_config.engine_deac_scale_pct.value)],' ','_');
    end
end
