% single-axle-equivalent calculations (Class8):
if isequal(vehicle.class, '8') && ~isempty(strfind(vehicle.type, 'comb'))  %jlb 2015-01-21
    if REVS.verbose disp('Class 8 Tractor-Trailer Single Axle Equivalent'); end

    if vehicle.axle_configuration == enum_driveline_type.C8_tractor_short_trailer  %jlb 2015-01-21
        % for short "pup" trailer, zero out trailer_axle2 params for
        % calculation purposes:
        vehicle.trailer_axle2.brake.inertia_kgm2 = 0;
        vehicle.trailer_axle2.tire.inertia_kgm2 = 0;
        vehicle.trailer_axle2.tire.rolling_resistance_coefficient = 0;
        vehicle.trailer_axle2.tire.vehicle_weight_norm = 0;
        vehicle.trailer_axle2.brake.proportion_norm = 0;
    end
    
    vehicle.axle_configuration = enum_driveline_type.one_axle_drive;
    vehicle.axle_count = 1;

    vehicle.drive_axle.final_drive.gear_ratio = vehicle.transfer_case.prop1_torque_ratio * vehicle.drive_axle1.final_drive.gear_ratio + ...
                                                (1-vehicle.transfer_case.prop1_torque_ratio) * vehicle.drive_axle2.final_drive.gear_ratio;

    vehicle.drive_axle.final_drive.inertia_kgm2  = ...
                               (vehicle.driveshaft.inertia_kgm2*vehicle.transfer_case.gear_ratio^2 + vehicle.transfer_case.inertia_kgm2)* vehicle.drive_axle.final_drive.gear_ratio^2 +  ... 
                               vehicle.drive_axle1.final_drive.inertia_kgm2 + ...
                               vehicle.drive_axle2.final_drive.inertia_kgm2;

    vehicle.drive_axle.final_drive.efficiency_norm = vehicle.driveshaft.efficiency_norm * ... 
                                                     vehicle.transfer_case.efficiency_norm * ...
                                                     (vehicle.transfer_case.prop1_torque_ratio * vehicle.drive_axle1.final_drive.efficiency_norm + ...
                                                     (1-vehicle.transfer_case.prop1_torque_ratio) * vehicle.drive_axle2.final_drive.efficiency_norm);

    vehicle.drive_axle.brake.proportion_norm = 1.0;

    vehicle.drive_axle.brake.inertia_kgm2 = ... 
        vehicle.steer_axle.brake.inertia_kgm2 + ...
        vehicle.drive_axle1.brake.inertia_kgm2 + ...
        vehicle.drive_axle2.brake.inertia_kgm2 + ...
        vehicle.trailer_axle1.brake.inertia_kgm2 + ...
        vehicle.trailer_axle2.brake.inertia_kgm2;

    vehicle.drive_axle.tire.vehicle_weight_norm = 1.0;

    vehicle.drive_axle.tire.radius_m =  vehicle.transfer_case.prop1_torque_ratio * vehicle.drive_axle1.tire.radius_m + ...
                                        (1-vehicle.transfer_case.prop1_torque_ratio) * vehicle.drive_axle2.tire.radius_m ;

    vehicle.drive_axle.tire.inertia_kgm2 = ... 
        vehicle.steer_axle.tire.inertia_kgm2 + ...
        vehicle.drive_axle1.tire.inertia_kgm2 + ...
        vehicle.drive_axle2.tire.inertia_kgm2 + ...
        vehicle.trailer_axle1.tire.inertia_kgm2 + ...
        vehicle.trailer_axle2.tire.inertia_kgm2;

    vehicle.drive_axle.tire.rolling_resistance_coefficient = ...
        vehicle.steer_axle.tire.rolling_resistance_coefficient * vehicle.steer_axle.tire.vehicle_weight_norm + ...
        vehicle.drive_axle1.tire.rolling_resistance_coefficient * vehicle.drive_axle1.tire.vehicle_weight_norm + ...
        vehicle.drive_axle2.tire.rolling_resistance_coefficient * vehicle.drive_axle2.tire.vehicle_weight_norm + ...
        vehicle.trailer_axle1.tire.rolling_resistance_coefficient * vehicle.trailer_axle1.tire.vehicle_weight_norm + ...
        vehicle.trailer_axle2.tire.rolling_resistance_coefficient * vehicle.trailer_axle2.tire.vehicle_weight_norm;
elseif isequal(vehicle.class, '7') && ~isempty(strfind(vehicle.type, 'comb'))
    if REVS.verbose disp('Class 7 Tractor-Trailer Single Axle Equivalent'); end

    if vehicle.axle_configuration == enum_driveline_type.C7_tractor_short_trailer
        % for short "pup" trailer, zero out trailer_axle2 params for
        % calculation purposes:
        vehicle.trailer_axle2.brake.inertia_kgm2 = 0;
        vehicle.trailer_axle2.tire.inertia_kgm2 = 0;
        vehicle.trailer_axle2.tire.rolling_resistance_coefficient = 0;
        vehicle.trailer_axle2.tire.vehicle_weight_norm = 0;
        vehicle.trailer_axle2.brake.proportion_norm = 0;
    end

    vehicle.axle_configuration = enum_driveline_type.one_axle_drive;
    vehicle.axle_count = 1;
    
    vehicle.drive_axle.final_drive.gear_ratio = vehicle.drive_axle1.final_drive.gear_ratio;

    vehicle.drive_axle.final_drive.inertia_kgm2  = ...
                               vehicle.driveshaft.inertia_kgm2 * vehicle.drive_axle.final_drive.gear_ratio^2 + ... 
                               vehicle.drive_axle1.final_drive.inertia_kgm2;

    vehicle.drive_axle.final_drive.efficiency_norm = vehicle.driveshaft.efficiency_norm * ... 
                                                     vehicle.drive_axle1.final_drive.efficiency_norm;
    vehicle.drive_axle.brake.proportion_norm = 1.0;

    vehicle.drive_axle.brake.inertia_kgm2 = ... 
        vehicle.steer_axle.brake.inertia_kgm2 + ...
        vehicle.drive_axle1.brake.inertia_kgm2 + ...
        vehicle.trailer_axle1.brake.inertia_kgm2 + ...
        vehicle.trailer_axle2.brake.inertia_kgm2;

    vehicle.drive_axle.tire.vehicle_weight_norm = 1.0;

    vehicle.drive_axle.tire.radius_m =  vehicle.drive_axle1.tire.radius_m;

    vehicle.drive_axle.tire.inertia_kgm2 = ... 
        vehicle.steer_axle.tire.inertia_kgm2 + ...
        vehicle.drive_axle1.tire.inertia_kgm2 + ...
        vehicle.trailer_axle1.tire.inertia_kgm2 + ...
        vehicle.trailer_axle2.tire.inertia_kgm2;

    vehicle.drive_axle.tire.rolling_resistance_coefficient = ...
        vehicle.steer_axle.tire.rolling_resistance_coefficient * vehicle.steer_axle.tire.vehicle_weight_norm + ...
        vehicle.drive_axle1.tire.rolling_resistance_coefficient * vehicle.drive_axle1.tire.vehicle_weight_norm + ...
        vehicle.trailer_axle1.tire.rolling_resistance_coefficient * vehicle.trailer_axle1.tire.vehicle_weight_norm + ...
        vehicle.trailer_axle2.tire.rolling_resistance_coefficient * vehicle.trailer_axle2.tire.vehicle_weight_norm;
elseif isequal(vehicle.class, 'HHD') && isequal(vehicle.type,'voc')
    if REVS.verbose disp('HHD (Class 8) Vocational Single Axle Equivalent'); end
    vehicle.axle_configuration = enum_driveline_type.one_axle_drive;
    vehicle.axle_count = 1;

    vehicle.drive_axle.final_drive.gear_ratio = vehicle.transfer_case.prop1_torque_ratio * vehicle.drive_axle1.final_drive.gear_ratio + ...
                                                (1-vehicle.transfer_case.prop1_torque_ratio) * vehicle.drive_axle2.final_drive.gear_ratio;

    vehicle.drive_axle.final_drive.inertia_kgm2  = ...
                               (vehicle.driveshaft.inertia_kgm2*vehicle.transfer_case.gear_ratio^2 + vehicle.transfer_case.inertia_kgm2)* vehicle.drive_axle.final_drive.gear_ratio^2 +  ... 
                               vehicle.drive_axle1.final_drive.inertia_kgm2 + ...
                               vehicle.drive_axle2.final_drive.inertia_kgm2;

    vehicle.drive_axle.final_drive.efficiency_norm = vehicle.driveshaft.efficiency_norm * ... 
                                                     vehicle.transfer_case.efficiency_norm * ...
                                                     (vehicle.transfer_case.prop1_torque_ratio * vehicle.drive_axle1.final_drive.efficiency_norm + ...
                                                     (1-vehicle.transfer_case.prop1_torque_ratio) * vehicle.drive_axle2.final_drive.efficiency_norm);

    vehicle.drive_axle.brake.proportion_norm = 1.0;

    vehicle.drive_axle.brake.inertia_kgm2 = ... 
        vehicle.steer_axle.brake.inertia_kgm2 + ...
        vehicle.drive_axle1.brake.inertia_kgm2 + ...
        vehicle.drive_axle2.brake.inertia_kgm2;

    vehicle.drive_axle.tire.vehicle_weight_norm = 1.0;

    vehicle.drive_axle.tire.radius_m =  vehicle.transfer_case.prop1_torque_ratio * vehicle.drive_axle1.tire.radius_m + ...
                                        (1-vehicle.transfer_case.prop1_torque_ratio) * vehicle.drive_axle2.tire.radius_m ;

    vehicle.drive_axle.tire.inertia_kgm2 = ... 
        vehicle.steer_axle.tire.inertia_kgm2 + ...
        vehicle.drive_axle1.tire.inertia_kgm2 + ...
        vehicle.drive_axle2.tire.inertia_kgm2;
    
    vehicle.drive_axle.tire.rolling_resistance_coefficient = ...
        vehicle.steer_axle.tire.rolling_resistance_coefficient * vehicle.steer_axle.tire.vehicle_weight_norm + ...
        vehicle.drive_axle1.tire.rolling_resistance_coefficient * vehicle.drive_axle1.tire.vehicle_weight_norm + ...
        vehicle.drive_axle2.tire.rolling_resistance_coefficient * vehicle.drive_axle2.tire.vehicle_weight_norm;
elseif isequal(vehicle.type,'voc')
    if REVS.verbose disp('Non-Class 8 Vocational Single Axle Equivalent'); end
    vehicle.axle_configuration = enum_driveline_type.one_axle_drive;
    vehicle.axle_count = 1;

    vehicle.drive_axle.final_drive.gear_ratio = vehicle.drive_axle1.final_drive.gear_ratio;

    vehicle.drive_axle.final_drive.inertia_kgm2  = ...
                               vehicle.driveshaft.inertia_kgm2 * vehicle.drive_axle.final_drive.gear_ratio^2 + ... 
                               vehicle.drive_axle1.final_drive.inertia_kgm2;

    vehicle.drive_axle.final_drive.efficiency_norm = vehicle.driveshaft.efficiency_norm * ... 
                                                     vehicle.drive_axle1.final_drive.efficiency_norm;
    vehicle.drive_axle.brake.proportion_norm = 1.0;

    vehicle.drive_axle.brake.inertia_kgm2 = ... 
        vehicle.steer_axle.brake.inertia_kgm2 + ...
        vehicle.drive_axle1.brake.inertia_kgm2;

    vehicle.drive_axle.tire.vehicle_weight_norm = 1.0;

    vehicle.drive_axle.tire.radius_m =  vehicle.drive_axle1.tire.radius_m;

    vehicle.drive_axle.tire.inertia_kgm2 = ... 
        vehicle.steer_axle.tire.inertia_kgm2 + ...
        vehicle.drive_axle1.tire.inertia_kgm2;

    vehicle.drive_axle.tire.rolling_resistance_coefficient = ...
        vehicle.steer_axle.tire.rolling_resistance_coefficient * vehicle.steer_axle.tire.vehicle_weight_norm + ...
        vehicle.drive_axle1.tire.rolling_resistance_coefficient * vehicle.drive_axle1.tire.vehicle_weight_norm;
end

vehicle.drive_axle1 = vehicle.drive_axle;

if isfield(vehicle,'steer_axle') 
    vehicle = rmfield(vehicle,'steer_axle');
end

if isfield(vehicle,'drive_axle') 
    vehicle = rmfield(vehicle,'drive_axle');
end

if isfield(vehicle,'drive_axle2')
    vehicle = rmfield(vehicle,'drive_axle2');
end

if isfield(vehicle,'trailer_axle1') 
    vehicle = rmfield(vehicle,'trailer_axle1');
end

if isfield(vehicle,'trailer_axle2') 
    vehicle = rmfield(vehicle,'trailer_axle2');
end

if isfield(vehicle,'transfer_case') 
    vehicle = rmfield(vehicle,'transfer_case');
end